/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.annotation;

import com.ge.med.StdAnno.ApStyle;
import com.ge.med.cse.cvf.annotation.XpApdAnnotationGenerator;
import com.ge.med.cse.cvf.annotation.XpCVAnnotation;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.annotation.XpApdAnnotation;
import java.util.Properties;
import java.util.StringTokenizer;

public class XpCVAnnotationGenerator
extends XpApdAnnotationGenerator {
    protected int[] annotKeys = null;
    protected static String language = System.getProperty("user.language", "en");
    private static String timedateFormatEnvValue = System.getenv("CTIDATETIMEFORMAT");
    private static String timedateFormatSysProp = System.getProperty("CTIDATETIMEFORMAT");

    public XpCVAnnotationGenerator() {
        this.setLanguage(this.getLanguage(language));
    }

    @Override
    public void setProperties(Properties p) {
        super.setProperties(p);
        this.resetLargeFontAnnotKeys();
    }

    private void resetLargeFontAnnotKeys() {
        String largefontkeys = this.getProperty("LargeFontKeys");
        if (largefontkeys != null) {
            StringTokenizer st = new StringTokenizer(largefontkeys, ",");
            if (st.countTokens() > 0) {
                this.annotKeys = new int[st.countTokens()];
                for (int i = 0; i < this.annotKeys.length; ++i) {
                    this.annotKeys[i] = Integer.parseInt(st.nextToken());
                }
            } else {
                this.annotKeys = null;
            }
        } else {
            this.annotKeys = null;
        }
    }

    protected void initAnnotModelSettings(XpCVAnnotation am) {
        String timedateFormat = this.getTimeDateFormat();
        if (timedateFormat != null) {
            am.setProperty("timedateFormat", timedateFormat);
        }
        am.setProperty("lang", language);
        am.setLargeFontRendering(this.annotKeys);
    }

    protected String getTimeDateFormat() {
        String timdateFormat = null;
        if (timedateFormatEnvValue != null) {
            timdateFormat = timedateFormatEnvValue;
        } else if (timedateFormatSysProp != null) {
            timdateFormat = timedateFormatSysProp;
        }
        return timdateFormat;
    }

    @Override
    protected XpApdAnnotation createApdAnnotation(XpDicomObject dobj, ApStyle aps) {
        XpCVAnnotation apdAnnot = new XpCVAnnotation(dobj, aps);
        this.initAnnotModelSettings(apdAnnot);
        return apdAnnot;
    }

    public int getLanguage(String lang) {
        if (lang.startsWith("en")) {
            language = "en_US";
            return 0;
        }
        if (lang.startsWith("es")) {
            language = "es_MX";
            return 1;
        }
        if (lang.startsWith("fr")) {
            language = "fr_FR";
            return 2;
        }
        if (lang.startsWith("de")) {
            language = "de_DE";
            return 4;
        }
        if (lang.startsWith("it")) {
            language = "it_IT";
            return 3;
        }
        if (lang.startsWith("pt")) {
            language = "pt_PT";
            return 5;
        }
        if (lang.startsWith("kr")) {
            language = "kr";
            return 8;
        }
        if (lang.startsWith("no") || lang.startsWith("nb") || lang.startsWith("nn")) {
            language = "nb_NO";
            return 6;
        }
        language = lang.startsWith("da") ? "da_DK" : (lang.startsWith("fi") ? "fi_FI" : (lang.startsWith("sv") ? "sv_SE" : (lang.startsWith("nl") ? "nl_NL" : "en_US")));
        return 0;
    }
}

