/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.WindowLevelCapable;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.event.ActionEvent;
import java.util.logging.Level;

public abstract class XpWWAction
extends BaseAction {
    protected double WW_MIN;
    protected double WW_MAX;

    @Override
    protected String getName() {
        return "WWAction";
    }

    @Override
    protected void configure() {
        super.configure();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        WindowLevelCapable winLevelCapable = this.getWindowLevelCapable();
        if (winLevelCapable != null) {
            String mod = this.getCurrentModality();
            this.WW_MIN = CvUtils.getMinWW(mod);
            this.WW_MAX = CvUtils.getMaxWW(mod);
            double wl = (winLevelCapable.getWinMax() + winLevelCapable.getWinMin()) / 2.0;
            String[] params = this.getParams();
            try {
                if (params != null && params.length > 0) {
                    Double ww = Double.parseDouble(params[0]);
                    this.setWindowing(wl, ww);
                    this.setParams(null);
                } else {
                    this.getLogger().log(Level.WARNING, "Missing WW argument");
                    this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INSUFF_PARAM"));
                }
            }
            catch (Exception ex) {
                this.getLogger().log(Level.WARNING, "Parsing error for WW argument", ex);
            }
        }
    }

    public void setWindowing(double wl, double ww) {
        if (ww > this.WW_MAX) {
            ww = this.WW_MAX;
        } else if (ww < this.WW_MIN) {
            ww = this.WW_MIN;
        }
        double min = wl - ww / 2.0;
        double max = min + ww;
        this.getWindowLevelCapable().setWinMinMax(min, max);
        this.getWindowLevelCapable().repaint();
    }

    public static class WWRightAction
    extends XpWWAction {
        private static final TransactionLogName wwRightTID = new TransactionLogName("WWRightKey");

        @Override
        protected void configure() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WindowLevelCapable winLevelCapable = this.getWindowLevelCapable();
            if (winLevelCapable != null) {
                this.getLogger().log(Level.INFO, "(0) Begin " + wwRightTID);
                String mod = this.getCurrentModality();
                double increment = this.getImageWWWLIncrement();
                this.WW_MIN = CvUtils.getMinWW(mod);
                this.WW_MAX = CvUtils.getMaxWW(mod);
                double wl = (winLevelCapable.getWinMax() + winLevelCapable.getWinMin()) / 2.0;
                double ww = winLevelCapable.getWinMax() - winLevelCapable.getWinMin() + increment;
                this.setWindowing(wl, ww);
                this.getLogger().log(Level.INFO, "(0) End " + wwRightTID);
            }
        }

        @Override
        protected String getName() {
            return "WWRightAction";
        }
    }

    public static class WWLeftAction
    extends XpWWAction {
        private static final TransactionLogName wwLeftTID = new TransactionLogName("WWLeftKey");

        @Override
        protected void configure() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WindowLevelCapable winLevelCapable = this.getWindowLevelCapable();
            if (winLevelCapable != null) {
                this.getLogger().log(Level.INFO, "(0) Begin = " + wwLeftTID);
                String mod = this.getCurrentModality();
                double increment = this.getImageWWWLIncrement();
                this.WW_MIN = CvUtils.getMinWW(mod);
                this.WW_MAX = CvUtils.getMaxWW(mod);
                double wl = (winLevelCapable.getWinMax() + winLevelCapable.getWinMin()) / 2.0;
                double ww = winLevelCapable.getWinMax() - winLevelCapable.getWinMin() - increment;
                this.setWindowing(wl, ww);
                this.getLogger().log(Level.INFO, "(0) End " + wwLeftTID);
            }
        }

        @Override
        protected String getName() {
            return "WWLeftAction";
        }
    }
}

