/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.WindowLevelCapable;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.event.ActionEvent;
import java.util.logging.Level;

public class XpWLAction
extends BaseAction {
    protected double WL_MIN;
    protected double WL_MAX;

    @Override
    protected String getName() {
        return "WLAction";
    }

    @Override
    protected void configure() {
        super.configure();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        WindowLevelCapable winLevelCapable = this.getWindowLevelCapable();
        if (winLevelCapable != null) {
            String mod = this.getCurrentModality();
            this.WL_MIN = CvUtils.getMinWL(mod);
            this.WL_MAX = CvUtils.getMaxWL(mod);
            double ww = winLevelCapable.getWinMax() - winLevelCapable.getWinMin();
            String[] params = this.getParams();
            try {
                if (params != null && params.length > 0) {
                    Double wl = Double.parseDouble(params[0]);
                    this.setWindowing(wl, ww);
                    this.setParams(null);
                } else {
                    this.getLogger().log(Level.WARNING, "Missing WL argument");
                    this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INSUFF_PARAM"));
                }
            }
            catch (Exception ex) {
                this.getLogger().log(Level.WARNING, "Parsing error for WL argument", ex);
            }
        }
    }

    protected void setWindowing(double wl, double ww) {
        if (wl > this.WL_MAX) {
            wl = this.WL_MAX;
        } else if (wl < this.WL_MIN) {
            wl = this.WL_MIN;
        }
        double min = wl - ww / 2.0;
        double max = min + ww;
        this.getWindowLevelCapable().setWinMinMax(min, max);
        this.getWindowLevelCapable().repaint();
    }

    public static class WLDownAction
    extends XpWLAction {
        private static final TransactionLogName wlDownTID = new TransactionLogName("WLDownKeyAction");
        private static final long serialVersionUID = 1L;

        @Override
        protected final void configure() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WindowLevelCapable winLevelCapable = this.getWindowLevelCapable();
            if (winLevelCapable != null) {
                this.getLogger().log(Level.INFO, "{0} Begin " + wlDownTID);
                String mod = this.getCurrentModality();
                double increment = this.getImageWWWLIncrement();
                this.WL_MIN = CvUtils.getMinWL(mod);
                this.WL_MAX = CvUtils.getMaxWL(mod);
                double wl = (winLevelCapable.getWinMax() + winLevelCapable.getWinMin()) / 2.0 - increment;
                double ww = winLevelCapable.getWinMax() - winLevelCapable.getWinMin();
                this.setWindowing(wl, ww);
                this.getLogger().log(Level.INFO, "{0} End " + wlDownTID);
            }
        }

        @Override
        protected String getName() {
            return "WLDownAction";
        }
    }

    public static class WLUpAction
    extends XpWLAction {
        private static final TransactionLogName wlUpTID = new TransactionLogName("WLUpKeyAction");

        @Override
        protected void configure() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WindowLevelCapable winLevelCapable = this.getWindowLevelCapable();
            if (winLevelCapable != null) {
                this.getLogger().log(Level.INFO, "{0} Begin " + wlUpTID);
                String mod = this.getCurrentModality();
                double increment = this.getImageWWWLIncrement();
                this.WL_MIN = CvUtils.getMinWL(mod);
                this.WL_MAX = CvUtils.getMaxWL(mod);
                double wl = (winLevelCapable.getWinMax() + winLevelCapable.getWinMin()) / 2.0 + increment;
                double ww = winLevelCapable.getWinMax() - winLevelCapable.getWinMin();
                this.setWindowing(wl, ww);
                this.getLogger().log(Level.INFO, "{0} End " + wlUpTID);
            }
        }

        @Override
        protected String getName() {
            return "WLUpAction";
        }
    }
}

