/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.textpage.TextPageManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.terra.jami.capable.FrameCapable;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;

public class XpTextPageSeriesAction
extends BaseAction {
    private transient PropertyChangeListener dataLsnr = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            XpTextPageSeriesAction.this.updateState();
        }
    };

    @Override
    protected String getName() {
        return "XP_TEXTPAGE_SERIES";
    }

    @Override
    public void setCapable(Capable cap) {
        if (this.getCapable() != null) {
            this.getCapable().removePropertyChangeListener("CONTENT_CHANGED", this.dataLsnr);
            this.getCapable().removePropertyChangeListener("ComponentSelection", this.dataLsnr);
            this.getCapable().removePropertyChangeListener("reference_vp_selection", this.dataLsnr);
        }
        super.setCapable(cap);
        this.getCapable().addPropertyChangeListener("CONTENT_CHANGED", this.dataLsnr);
        this.getCapable().addPropertyChangeListener("ComponentSelection", this.dataLsnr);
        this.getCapable().addPropertyChangeListener("reference_vp_selection", this.dataLsnr);
        this.updateState();
    }

    private void updateState() {
        FrameCapable fc = this.getFrameCapable();
        if (fc != null && fc.getNumFrames() > CvUtils.getLargeSeriesSize()) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
        TextPageManager.getInstance().setTextPageEnabled(TextPageManager.TextPageType.SERIES, this.isEnabled());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FrameCapable fc = this.getFrameCapable();
        if (fc != null && fc.getNumFrames() > CvUtils.getLargeSeriesSize()) {
            TextPageManager.getInstance().setTextPageEnabled(TextPageManager.TextPageType.SERIES, this.isEnabled());
            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("XP_SERIES_TOO_LAREG_FOR_CMD"));
            this.getLogger().log(Level.WARNING, "Series Text page not supported for series size > " + CvUtils.getLargeSeriesSize());
            return;
        }
        try {
            TextPageManager.getInstance().setCapable(this.getCapable());
            TextPageManager.getInstance().launchTextPage(TextPageManager.TextPageType.SERIES);
        }
        catch (Exception ex) {
            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("TP_DISPLAY_FAIL"));
            this.getLogger().log(Level.WARNING, "Unable to launch Text page series", ex);
        }
    }
}

