/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.idc.Capable;
import com.ge.med.terra.jami.capable.AnnotCapable;
import java.awt.event.ActionEvent;
import java.util.logging.Level;

public class XpShowHideAnnotationsAction
extends BaseAction {
    protected static final String showActionName = "XP_SHOW_ANNOTATIONS";
    protected static final String hideActionName = "XP_HIDE_ANNOTATIONS";
    protected static String actionName = "XP_HIDE_ANNOTATIONS";

    @Override
    protected String getName() {
        return actionName;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            AnnotCapable annotcap = this.getAnnotCapable();
            if (annotcap != null) {
                annotcap.setAnnotationVisible(!annotcap.isAnnotationVisible());
                this.reConfigure(annotcap.isAnnotationVisible());
            } else {
                this.getLogger().log(Level.INFO, "Viewport is not annotation capable. so this action can not be performed on this viewport");
            }
        }
        catch (Exception exp) {
            this.getLogger().log(Level.WARNING, "Exception during show/hide annotations, stack trace {0}", new Object[]{exp});
        }
    }

    @Override
    public void setCapable(Capable cap) {
        super.setCapable(cap);
        this.reConfigure(this.getAnnotCapable().isAnnotationVisible());
    }

    protected void reConfigure(boolean bol) {
        actionName = bol ? hideActionName : showActionName;
        super.configure();
    }
}

