/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.jami.XpUserAnnotationModel;
import com.ge.med.terra.jami.capable.UserAnnoCapable;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JComponent;

public class XpShowArrowAction
extends BaseAction {
    @Override
    protected String getName() {
        return "XP_SHOW_ARROW";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        UserAnnoCapable usrAnnot = this.getUserAnnotationCapable();
        String[] params = this.getParams();
        boolean showarrow = false;
        try {
            if (params == null) {
                this.getLogger().log(Level.WARNING, "On|Off parameter not passed");
                this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INSUFF_PARAM"));
                return;
            }
            if (params.length != 1) {
                this.getLogger().log(Level.WARNING, "Too many parameters");
                this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("TOO_MANY_PARAM"));
                return;
            }
            if (params[0].equalsIgnoreCase("on")) {
                showarrow = true;
            } else {
                if (!params[0].equalsIgnoreCase("off")) {
                    this.getLogger().log(Level.WARNING, "Invalid arrow parameter");
                    this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
                    return;
                }
                showarrow = false;
            }
            boolean status = this.showArrow(usrAnnot, showarrow);
            if (status) {
                ((JComponent)((Object)usrAnnot)).putClientProperty("Show_Arrow", new Boolean(showarrow));
            }
            this.setParams(null);
            return;
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public boolean showArrow(UserAnnoCapable usrAnnot, boolean isShow) {
        if (usrAnnot == null) {
            this.getLogger().log(Level.INFO, "UserAnnoCapable is null");
            return false;
        }
        if (CvUtils.isCinePlaying(usrAnnot)) {
            this.getLogger().log(Level.INFO, "Cine paging going on, cannot show/hide user annotation arrow");
            return false;
        }
        List annot = usrAnnot.getUserAnnos();
        for (XpUserAnnotationModel ua : annot) {
            if (!ua.isSelected()) continue;
            ua.setShowTarget(isShow);
        }
        usrAnnot.repaint();
        return true;
    }
}

