/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.cpanels.XPDisplayPrefsUtils;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class XpSeriesBindingAction
extends BaseAction {
    boolean isSeriesBindingOn = false;
    Logger logger = Logger.getLogger(this.getClass().getName());
    protected PropertyChangeListener pcl = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equalsIgnoreCase("Series_binding")) {
                XpSeriesBindingAction.this.isSeriesBindingOn = (Boolean)evt.getNewValue();
                XpSeriesBindingAction.this.configure(XpSeriesBindingAction.this.isSeriesBindingOn);
            }
        }
    };

    @Override
    protected String getName() {
        return "XP_SERBIND";
    }

    @Override
    public void setCapable(Capable cap) {
        super.setCapable(cap);
        ((JComponent)((Object)cap)).removePropertyChangeListener("Series_binding", this.pcl);
        ((JComponent)((Object)cap)).addPropertyChangeListener("Series_binding", this.pcl);
    }

    @Override
    protected void configure() {
        super.configure();
        this.isSeriesBindingOn = XPDisplayPrefsUtils.getSeriesBindingStatus();
        this.setToolTipHint(this.isSeriesBindingOn);
        this.setSelected(this.isSeriesBindingOn);
    }

    protected void configure(boolean seriesbinding) {
        this.setToolTipHint(seriesbinding);
        this.setSelected(seriesbinding);
    }

    private void setToolTipHint(boolean seriesBindingStatus) {
        if (seriesBindingStatus) {
            this.setToolTip(this.getI18NString(this.getName() + "_TOOLTIP"));
        } else {
            this.setToolTip(this.getI18NString(this.getName() + "_OFF" + "_TOOLTIP"));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TransactionLogName tln = new TransactionLogName("TID=CV_SeriesBinding");
        String[] params = this.getParams();
        if (params != null && params.length > 0) {
            this.setParams(null);
            if (params[0].toLowerCase().equals("on")) {
                this.isSeriesBindingOn = true;
            } else if (params[0].toLowerCase().equals("off")) {
                this.isSeriesBindingOn = false;
            } else {
                this.getLogger().log(Level.WARNING, "Invalid command argument");
                this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
            }
        } else {
            this.isSeriesBindingOn = !XPDisplayPrefsUtils.getSeriesBindingStatus();
        }
        try {
            this.logger.log(Level.FINEST, "{0} begin", tln);
            XPDisplayPrefsUtils.updateSeriesBindingStatus(this.isSeriesBindingOn);
            Container c = SwingUtilities.getAncestorOfClass(XPscreen.class, (Component)((Object)this.getCapable()));
            if (c != null) {
                ((XPscreen)c).putClientProperty("Series_binding", this.isSeriesBindingOn);
            } else if (this.getCapable() instanceof JComponent) {
                ((JComponent)((Object)this.getCapable())).putClientProperty("Series_binding", this.isSeriesBindingOn);
            }
            this.logger.log(Level.FINEST, "{0} end", tln);
        }
        catch (Exception exp) {
            this.getLogger().log(Level.WARNING, "Exception during series binding status update , {0}", new Object[]{exp});
        }
    }
}

