/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.ScreenSaveUtil;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import javax.swing.JComponent;

public class XpScreenSaveAction
extends BaseAction {
    private static final long serialVersionUID = 1L;
    private static final TransactionLogName tln = new TransactionLogName("TID=CV_screenSaveAction");
    private BufferedImage scrnSaveimage;
    private XpDicomElement examid = new XpDicomElement(32, 16);
    private XpDicomElement examuid = new XpDicomElement(32, 13);
    private XpDicomElement imageuid = new XpDicomElement(8, 24);

    @Override
    public String getName() {
        return "XP_SCREEN_SAVE";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.getLogger().log(Level.INFO, "{0} begin", tln);
        String status = this.doScreenSave();
        this.getLogger().log(Level.INFO, " {0} end", tln);
        this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString(status));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String doScreenSave() {
        InputStream is;
        block21: {
            Object img;
            DMObject dmObject;
            JComponent port;
            block22: {
                String[] params = this.getParams();
                if (params != null && params.length > 0) {
                    this.getLogger().log(Level.WARNING, "Invalid argument.");
                    this.setParams(null);
                    return "INV_PARAM";
                }
                port = this.getSelectedMainViewport();
                dmObject = null;
                is = null;
                if (port == null) break block21;
                XpImage frame = null;
                if (port instanceof FrameOwner && (frame = ((FrameOwner)((Object)port)).getFrame()) instanceof XpDicomObject) {
                    img = (XpDicomObject)((Object)frame);
                    img.getValue(this.examid);
                    img.getValue(this.examuid);
                    img.getValue(this.imageuid);
                    String query = "(0x0020, 0x000D) = " + this.examuid.value;
                    if (this.examid.value != null && this.examid.getStringValue().trim().length() > 0) {
                        query = query + " AND (0x0020, 0x0010) = " + this.examid.value;
                    }
                    query = query + " AND (0x0008, 0x0018) = " + this.imageuid.value;
                    DMObject[] dmo = CvUtils.getDMSystem().getLocalDB().getRelated("image", new DMQuery(query));
                    if (dmo != null && dmo.length > 0) {
                        dmObject = dmo[0];
                    }
                } else {
                    dmObject = CvUtils.getDMSystem().getRepresentativeDMObjet();
                }
                if (dmObject != null) break block22;
                this.getLogger().log(Level.WARNING, "Representative DMObject is NULL !!!");
                img = "SCNSAVE_FAIL";
                if (is == null) return img;
                try {
                    is.close();
                    return img;
                }
                catch (IOException exp) {
                    this.getLogger().log(Level.WARNING, "Exception during closing inputstream", new Object[]{exp});
                    exp.printStackTrace();
                }
                return img;
            }
            is = ScreenSaveUtil.getScreenCapture(dmObject, port, 512, 512, null);
            CvUtils.getDMSystem().getLocalDB().install(is);
            img = "SCNSAVE_DONE";
            if (is == null) return img;
            try {
                is.close();
                return img;
            }
            catch (IOException exp) {
                this.getLogger().log(Level.WARNING, "Exception during closing inputstream", new Object[]{exp});
                exp.printStackTrace();
            }
            return img;
        }
        this.getLogger().log(Level.WARNING, "No Port is selected");
        String frame = "SCNSAVE_FAIL";
        if (is == null) return frame;
        try {
            is.close();
            return frame;
        }
        catch (IOException exp) {
            this.getLogger().log(Level.WARNING, "Exception during closing inputstream", new Object[]{exp});
            exp.printStackTrace();
        }
        return frame;
        catch (Exception exp) {
            try {
                this.getLogger().log(Level.WARNING, "Exception during Screen Save creation", new Object[]{exp});
                if (is == null) return "SCNSAVE_FAIL";
            }
            catch (Throwable throwable) {
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException exp2) {
                    this.getLogger().log(Level.WARNING, "Exception during closing inputstream", new Object[]{exp2});
                    exp2.printStackTrace();
                }
                throw throwable;
            }
            try {
                is.close();
                return "SCNSAVE_FAIL";
            }
            catch (IOException exp3) {
                this.getLogger().log(Level.WARNING, "Exception during closing inputstream", new Object[]{exp3});
                exp3.printStackTrace();
            }
            return "SCNSAVE_FAIL";
        }
    }
}

