/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.cpanels.XPDisplayPrefsUtils;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.jami.capable.AnnotCapable;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import javax.swing.JComponent;

public class XpScreenAnnotGroupAction
extends BaseAction {
    @Override
    protected String getName() {
        return "XP_ANN_GROUP";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TransactionLogName tln = new TransactionLogName("TID=CV_annotationGroup_custom");
        try {
            String[] params = this.getParams();
            AnnotCapable annotCap = this.getAnnotCapable();
            if (params != null) {
                int length = params.length;
                if (length < 2) {
                    this.getLogger().log(Level.WARNING, "Missing some argument");
                    this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INSUFF_PARAM"));
                } else if (length > 2) {
                    this.getLogger().log(Level.WARNING, "Too many argument");
                    this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("TOO_MANY_PARAM"));
                } else {
                    String imgType = CvUtils.getImageTypeKey(annotCap);
                    if (imgType == null) {
                        this.getLogger().log(Level.WARNING, "{0} SEV5 image type could not be evaluated", tln);
                        return;
                    }
                    boolean onoff = false;
                    if (params[0].equalsIgnoreCase("on")) {
                        onoff = true;
                    } else if (params[0].equalsIgnoreCase("off")) {
                        onoff = false;
                    } else {
                        this.getLogger().log(Level.WARNING, "{0} SEV5 Invalid argument", tln);
                        this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
                        return;
                    }
                    int index = Integer.parseInt(params[1]);
                    String[] groups = XPDisplayPrefsUtils.getCustomAnnotationGroups(annotCap, imgType);
                    if (groups == null || index < 1 || index > groups.length) {
                        this.getLogger().log(Level.WARNING, "{0} SEV5 NULL Custom groups", tln);
                        return;
                    }
                    int mask = XPDisplayPrefsUtils.getScreenCustomAnnotationLevel();
                    mask = onoff ? (mask |= XPDisplayPrefsUtils.getCustomAnnotationGroupMask(index - 1)) : (mask &= ~XPDisplayPrefsUtils.getCustomAnnotationGroupMask(index - 1));
                    XPDisplayPrefsUtils.updateScreenCustomAnnotationLevel(mask);
                    annotCap.setAnnotationItems(new String[]{groups[index - 1]}, onoff);
                    annotCap.repaint();
                    ((JComponent)((Object)annotCap)).putClientProperty("screen_custom_annotation_level", new Integer(mask));
                }
            } else {
                this.getLogger().log(Level.WARNING, "Argument missing");
                this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INSUFF_PARAM"));
            }
        }
        catch (Exception ex) {
            this.getLogger().log(Level.WARNING, "Invalid argument", ex);
            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
        }
    }
}

