/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.WindowLevelCapable;
import com.ge.med.terra.jami.XpImage2DVc;
import com.ge.med.terra.jami.XpSingularPort;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.JComponent;

public class XpReturnToPreviousWWWLAction
extends BaseAction {
    protected static final TransactionLogName previousWWWLTID = new TransactionLogName("XpReturnToPreviousWWWLAction");
    protected double wwMin;
    protected double wwMax;
    protected double wlMin;
    protected double wlMax;
    protected transient Map<XpViewport, PortWWWLRecord> portToWWWLMap = new HashMap<XpViewport, PortWWWLRecord>();
    protected double winMaxPrevious = 0.0;
    protected double winMinPrevious = 0.0;
    private boolean isMouseDrag = false;
    private transient PropertyChangeListener vpListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JComponent vp;
            if (evt.getPropertyName().equals("winMax")) {
                if (!XpReturnToPreviousWWWLAction.this.isMouseDrag) {
                    XpReturnToPreviousWWWLAction.this.winMaxPrevious = (Double)evt.getOldValue();
                    XpReturnToPreviousWWWLAction.this.updatePortWWWlRecord();
                }
            } else if (evt.getPropertyName().equals("winMin")) {
                if (!XpReturnToPreviousWWWLAction.this.isMouseDrag) {
                    XpReturnToPreviousWWWLAction.this.winMinPrevious = (Double)evt.getOldValue();
                    XpReturnToPreviousWWWLAction.this.updatePortWWWlRecord();
                }
            } else if (evt.getPropertyName().equals("CONTENT_CHANGED")) {
                JComponent selport;
                PortWWWLRecord portWWWLRecord;
                if (XpReturnToPreviousWWWLAction.this.getCapable() != null && XpReturnToPreviousWWWLAction.this.getCapable() instanceof XPscreen && (portWWWLRecord = XpReturnToPreviousWWWLAction.this.portToWWWLMap.get(selport = ((XPscreen)XpReturnToPreviousWWWLAction.this.getCapable()).getSelectedPort())) != null) {
                    portWWWLRecord.setWWWLChanged(false);
                }
            } else if (evt.getPropertyName().equals("ComponentSelection") && (vp = XpReturnToPreviousWWWLAction.this.getSelectedViewport()) != null && vp instanceof XpSingularPort && ((XpSingularPort)vp).getMouseController() != null) {
                XpImage2DVc imageVc = ((XpSingularPort)vp).getMedicalImageVc().getImageVc();
                imageVc.removeMouseListener(XpReturnToPreviousWWWLAction.this.mouseListener);
                imageVc.addMouseListener(XpReturnToPreviousWWWLAction.this.mouseListener);
                imageVc.removeMouseMotionListener(XpReturnToPreviousWWWLAction.this.mouseListener);
                imageVc.addMouseMotionListener(XpReturnToPreviousWWWLAction.this.mouseListener);
            }
        }
    };
    transient MouseAdapter mouseListener = new MouseAdapter(){

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!XpReturnToPreviousWWWLAction.this.isMouseDrag) {
                XpReturnToPreviousWWWLAction.this.winMaxPrevious = XpReturnToPreviousWWWLAction.this.getWindowLevelCapable().getWinMax();
                XpReturnToPreviousWWWLAction.this.winMinPrevious = XpReturnToPreviousWWWLAction.this.getWindowLevelCapable().getWinMin();
                XpReturnToPreviousWWWLAction.this.updatePortWWWlRecord();
            }
            XpReturnToPreviousWWWLAction.this.isMouseDrag = true;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            XpReturnToPreviousWWWLAction.this.isMouseDrag = false;
        }
    };

    @Override
    protected String getName() {
        return "XP_RETURN_TO_PREVIOUS_WWWL";
    }

    @Override
    public void setCapable(Capable cap) {
        super.setCapable(cap);
        cap.removePropertyChangeListener(this.vpListener);
        cap.addPropertyChangeListener(this.vpListener);
    }

    private void updatePortWWWlRecord() {
        if (this.getCapable() != null && this.getCapable() instanceof XPscreen) {
            JComponent selport = ((XPscreen)this.getCapable()).getSelectedPort();
            if (selport != null && selport instanceof XpViewport) {
                PortWWWLRecord portWWWLRecord = this.portToWWWLMap.get(selport);
                if (portWWWLRecord == null) {
                    portWWWLRecord = new PortWWWLRecord();
                }
                portWWWLRecord.setPreviousWinMax(this.winMaxPrevious);
                portWWWLRecord.setPreviousWinMin(this.winMinPrevious);
                portWWWLRecord.setWWWLChanged(true);
                this.portToWWWLMap.put((XpViewport)selport, portWWWLRecord);
            } else {
                this.getLogger().log(Level.INFO, "Selected port is either Null or not type of XpViewport");
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.getLogger().log(Level.INFO, "{0} Begin " + previousWWWLTID);
        if (this.getCapable() == null) {
            this.getLogger().log(Level.INFO, "Capable is Null");
            return;
        }
        JComponent selport = ((XPscreen)this.getCapable()).getSelectedPort();
        if (selport == null || !(selport instanceof XpViewport)) {
            this.getLogger().log(Level.INFO, "Selected port is either Null or not type of XpViewport");
            return;
        }
        if (this.portToWWWLMap.get(selport) == null || !this.portToWWWLMap.get(selport).isWWWLChanged()) {
            return;
        }
        WindowLevelCapable winLevelCapable = this.getWindowLevelCapable();
        if (winLevelCapable != null) {
            double winMaxPrev = this.portToWWWLMap.get(selport).getPreviousWinMax();
            double winMinPrev = this.portToWWWLMap.get(selport).getPreviousWinMin();
            if (winLevelCapable.getWinMax() == winMaxPrev && winLevelCapable.getWinMin() == winMinPrev) {
                return;
            }
            String mod = this.getCurrentModality();
            this.wwMin = CvUtils.getMinWW(mod);
            this.wwMax = CvUtils.getMaxWW(mod);
            this.wlMin = CvUtils.getMinWL(mod);
            this.wlMax = CvUtils.getMaxWL(mod);
            double ww = winMaxPrev - winMinPrev;
            double wl = (winMaxPrev + winMinPrev) / 2.0;
            this.setWindowing(wl, ww);
            this.getLogger().log(Level.INFO, "Returning to previous WW = " + ww + " and WL = " + wl);
        }
        this.getLogger().log(Level.INFO, "{0} End " + previousWWWLTID);
    }

    protected void setWindowing(double wl, double ww) {
        if (ww > this.wwMax) {
            ww = this.wwMax;
        } else if (ww < this.wwMin) {
            ww = this.wwMin;
        }
        if (wl > this.wlMax) {
            wl = this.wlMax;
        } else if (wl < this.wlMin) {
            wl = this.wlMin;
        }
        double min = wl - ww / 2.0;
        double max = min + ww;
        this.getWindowLevelCapable().setWinMinMax(min, max);
        this.getWindowLevelCapable().repaint();
    }

    private class PortWWWLRecord {
        private boolean isWWWLChanged = false;
        private double previousWinMax;
        private double previousWinMin;

        public void setPreviousWinMax(double winMax) {
            this.previousWinMax = winMax;
        }

        public double getPreviousWinMax() {
            return this.previousWinMax;
        }

        public void setPreviousWinMin(double winMin) {
            this.previousWinMin = winMin;
        }

        public double getPreviousWinMin() {
            return this.previousWinMin;
        }

        public void setWWWLChanged(boolean isWWWLChanged) {
            this.isWWWLChanged = isWWWLChanged;
        }

        public boolean isWWWLChanged() {
            return this.isWWWLChanged;
        }
    }
}

