/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.crossref.XpReferenceImageApp;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.xpv.base.XPscreen;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JMenuItem;

public class XpReferenceImageAllOnAction
extends BaseAction {
    @Override
    protected String getName() {
        return "XP_REFERENCE_IMAGE_ALL_ON";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block17: {
            try {
                JComponent port = this.getSelectedPort();
                if (port == null) {
                    this.getLogger().log(Level.WARNING, "Selected port is null.");
                    return;
                }
                if (XpReferenceImageApp.getRefImageContext() == 4) {
                    this.getLogger().log(Level.WARNING, "Cross Reference mode is already on.");
                    return;
                }
                String[] params = this.getParams();
                this.setParams(null);
                if (params != null && params.length > 0) {
                    int senum = -1;
                    int imnum = -1;
                    if (params.length < 3) {
                        try {
                            switch (params.length) {
                                case 1: {
                                    senum = Integer.parseInt(params[0]);
                                    break;
                                }
                                case 2: {
                                    senum = Integer.parseInt(params[0]);
                                    imnum = Integer.parseInt(params[1]);
                                }
                            }
                        }
                        catch (NumberFormatException ex) {
                            this.getLogger().log(Level.INFO, "Serial/Image no. is not integer, stack trace {0}", new Object[]{ex});
                        }
                        if (port instanceof XpViewport) {
                            XpReferenceImageApp.postReferenceImage((XpViewport)port, false, senum, imnum, false);
                        } else {
                            this.getLogger().log(Level.WARNING, "Selected port is not instance of XpViewport.");
                        }
                        break block17;
                    }
                    this.getLogger().log(Level.INFO, "Too many parameters.");
                    this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("TOO_MANY_PARAM"));
                    break block17;
                }
                if (e.getSource() instanceof JMenuItem) {
                    XpReferenceImageApp.setRefImageContext(0);
                }
                if (port instanceof XpViewport) {
                    XpReferenceImageApp.postReferenceImage((XpViewport)port, false, false);
                } else {
                    this.getLogger().log(Level.WARNING, "Selected port is not instance of XpViewport.");
                }
            }
            catch (Exception exp) {
                this.getLogger().log(Level.WARNING, "Exception during 'all reference image viewport on' operation, stack trace {0}", new Object[]{exp});
            }
        }
    }

    private JComponent getSelectedPort() {
        JComponent com = (JComponent)((Object)this.getCapable());
        while (com != null && com instanceof XPscreen) {
            com = ((XPscreen)com).getSelectedPort();
        }
        return com;
    }
}

