/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.base.CvImageLoader;
import com.ge.med.cse.cvf.idc.PagingCapable;
import com.ge.med.cse.cvf.idc.XpLinkPortCapable;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.util.CPIUtils;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.CineCapable;
import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class XpNextSeriesAction
extends BaseAction {
    private Thread loaderThread = null;
    private Capable compcap = null;
    private static final XpDicomElement eid = new XpDicomElement(32, 16);
    private static final XpDicomElement euid = new XpDicomElement(32, 13);
    private static final XpDicomElement suid = new XpDicomElement(32, 14);
    private static final TransactionLogName tln = new TransactionLogName("TID=CV_NextSeriesAction");
    private transient PropertyChangeListener paginglistener = new PropertyChangeListener(){
        boolean val;

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("paging_property")) {
                this.val = (Boolean)evt.getNewValue();
                XpNextSeriesAction.this.setEnabled(this.val);
            }
        }
    };

    @Override
    protected String getName() {
        return "XP_NEXT_SERIES";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.loaderThread != null && this.loaderThread.isAlive()) {
            this.getLogger().log(Level.INFO, "{0} An ESI load action already processing", tln);
            return;
        }
        CineCapable cc = (CineCapable)this.getCapable().getCapable(CineCapable.class.getName());
        if (cc != null && cc.getCine()) {
            this.getLogger().log(Level.INFO, "{0} Cine on, cannot process load series request", tln);
            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("CINE_ON_IMGLOAD_FAILED"));
            return;
        }
        XpLinkPortCapable lpcap = (XpLinkPortCapable)this.getCapable().getCapable(XpLinkPortCapable.class.getName());
        if (lpcap != null && lpcap.getPortsLinked()) {
            this.getLogger().log(Level.SEVERE, "{0} Unlink ports to load a different exam/series", tln);
            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("UNLINK_PORT_TOLOAD_EXAM"));
            return;
        }
        this.loaderThread = new Thread(){

            @Override
            public void run() {
                DMObject[] objs;
                XpMedicalImage image = null;
                FrameOwner fpc = (FrameOwner)((Object)XpNextSeriesAction.this.getCapable().getCapable(FrameOwner.class.getName()));
                if (fpc != null && fpc.getFrame() instanceof XpMedicalImage) {
                    image = (XpMedicalImage)fpc.getFrame();
                }
                if (image == null) {
                    XpNextSeriesAction.this.getLogger().info("Selected port is empty");
                    return;
                }
                DMSession sess = CvUtils.getDMSystem().getLocalDB();
                if (sess == null) {
                    XpNextSeriesAction.this.getLogger().info("No DMSystem found");
                    return;
                }
                image.getValue(eid);
                image.getValue(euid);
                image.getValue(suid);
                String query = "(0x0020, 0x000D) = " + euid.getStringValue();
                if (eid.getStringValue() != null && eid.getStringValue().trim().length() > 0) {
                    query = query + " AND (0x0020, 0x0010) = " + eid.getStringValue();
                }
                if ((objs = sess.getRelated("series", new DMQuery(query = query + " AND (0x0020, 0x000E) = " + suid.getStringValue()))) == null || objs.length == 0) {
                    XpNextSeriesAction.this.getLogger().info("Current series query returned null, query : " + query);
                    return;
                }
                DMObject current = objs[0];
                DMObject sel = null;
                if (current != null) {
                    do {
                        DMObject next;
                        if ((next = CvUtils.getDMSystem().getNextInBrowser(current, false)) == null) continue;
                        if (current.equals(next)) break;
                        if (CvImageLoader.getInstance().isValid(new DMObject[]{next}) && !CPIUtils.isGSPS(next)) {
                            sel = next;
                        }
                        current = next;
                    } while (sel == null && !objs[0].equals(current));
                }
                if (sel != null && XpNextSeriesAction.this.isFromSameExam(objs[0], sel)) {
                    CvUtils.getDMSystem().setSelection(new DMObject[]{sel});
                    final XpViewport selectedPort = XpNextSeriesAction.this.findSelectedViewportByClass(XpCompositePort.class);
                    final DMObject selection = sel;
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                if (selectedPort instanceof XpCompositePort) {
                                    CvImageLoader.getInstance().loadData((XpCompositePort)selectedPort, new DMObject[]{selection}, true);
                                } else {
                                    XpNextSeriesAction.this.getLogger().log(Level.WARNING, "Selected viewport is not a XpCompositePort");
                                }
                            }
                        });
                    }
                    catch (InterruptedException e) {
                        if (selectedPort instanceof XpCompositePort) {
                            XpNextSeriesAction.this.getLogger().info("Loading in normal way in thread");
                            CvImageLoader.getInstance().loadData((XpCompositePort)selectedPort, new DMObject[]{selection}, true);
                        } else {
                            XpNextSeriesAction.this.getLogger().log(Level.WARNING, "Selected viewport is not a XpCompositePort");
                        }
                    }
                    catch (InvocationTargetException e) {
                        if (selectedPort instanceof XpCompositePort) {
                            XpNextSeriesAction.this.getLogger().info("Loading in normal way in thread");
                            CvImageLoader.getInstance().loadData((XpCompositePort)selectedPort, new DMObject[]{selection}, true);
                        }
                        XpNextSeriesAction.this.getLogger().log(Level.WARNING, "Selected viewport is not a XpCompositePort");
                    }
                }
            }
        };
        if (this.compcap != null && ((PagingCapable)this.compcap).isPagingOn()) {
            this.loaderThread.setName("ImageLoader_NextSeries");
            this.loaderThread.start();
        }
    }

    @Override
    public void setCapable(Capable cap) {
        this.compcap = cap;
        if (!(cap instanceof JComponent)) {
            this.compcap = cap.getCapable(PagingCapable.class.getName());
        }
        if (this.compcap != null && this.compcap instanceof JComponent) {
            super.setCapable(this.compcap);
            this.compcap.removePropertyChangeListener(this.paginglistener);
            this.compcap.addPropertyChangeListener(this.paginglistener);
        }
    }

    private boolean isFromSameExam(DMObject current, DMObject next) {
        return current.getValue(32, 13).equals(next.getValue(32, 13)) && current.getValue(32, 16).equals(next.getValue(32, 16));
    }
}

