/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.controls.CvMouseControllerUtil;
import com.ge.med.cse.cvf.idc.MouseModeCapable;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.jami.XpSingularPort;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;

public class XpMouseModeLegacySettingsAction
extends BaseAction {
    private static final Logger logger = Logger.getLogger(XpMouseModeLegacySettingsAction.class.getName());
    protected String appName = "";
    protected MouseModeCapable mouseModeCapable = null;

    @Override
    protected String getName() {
        return "XP_MOUSEMODE_LEGACY_SETTINGS";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        logger.log(Level.INFO, "XpMouseModeLegacySettingsAction.actionPerformed()");
        try {
            JComponent com = this.getSelectedViewport();
            if (com instanceof XpSingularPort) {
                this.mouseModeCapable = (MouseModeCapable)((Object)((XpSingularPort)com).getMouseController());
            }
            String modality = CvUtils.getCurrentModality(this.getCapable());
            String prefix = (this.appName != null && this.appName.length() > 0 ? this.appName + "." : "") + "MouseMenu.Controller";
            String modeProp = prefix + CvMouseControllerUtil.getMouseButtonDefaultConstant(1024) + "." + modality.toLowerCase();
            String defaultMouseModeStr = CvPropertiesManager.getProperty(modeProp);
            if (defaultMouseModeStr != null) {
                this.mouseModeCapable.setMouseMode(Integer.parseInt(defaultMouseModeStr), 1024);
            }
            if ((defaultMouseModeStr = CvPropertiesManager.getProperty(modeProp = prefix + CvMouseControllerUtil.getMouseButtonDefaultConstant(2048) + "." + modality.toLowerCase())) != null) {
                this.mouseModeCapable.setMouseMode(Integer.parseInt(defaultMouseModeStr), 2048);
            }
            if ((defaultMouseModeStr = CvPropertiesManager.getProperty(modeProp = prefix + CvMouseControllerUtil.getMouseButtonDefaultConstant(4096) + "." + modality.toLowerCase())) != null) {
                this.mouseModeCapable.setMouseMode(Integer.parseInt(defaultMouseModeStr), 4096);
            }
        }
        catch (Exception exp) {
            this.getLogger().log(Level.WARNING, "Exception during mouse mode Legacy default settings operation, stack trace {0}", new Object[]{exp});
        }
    }
}

