/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.controls.CvMouseControllerUtil;
import com.ge.med.cse.cvf.idc.MouseModeCapable;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.terra.jami.XpSingularPort;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;

public class XpMouseModeAWSettingsAction
extends BaseAction {
    private static final Logger logger = Logger.getLogger(XpMouseModeAWSettingsAction.class.getName());
    protected String appName = "";
    protected MouseModeCapable mouseModeCapable = null;

    @Override
    protected String getName() {
        return "XP_MOUSEMODE_AW_SETTINGS";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        logger.log(Level.INFO, "XpMouseModeAWSettingsAction.actionPerformed()");
        try {
            JComponent com = this.getSelectedViewport();
            if (com instanceof XpSingularPort) {
                this.mouseModeCapable = (MouseModeCapable)((Object)((XpSingularPort)com).getMouseController());
            }
            if (this.mouseModeCapable != null) {
                String prefix = (this.appName != null && this.appName.length() > 0 ? this.appName + "." : "") + "MouseMenu.Controller";
                String modeProp = prefix + CvMouseControllerUtil.getMouseButtonDefaultConstant(1024) + ".aw";
                String defaultMouseModeStr = CvPropertiesManager.getProperty(modeProp);
                if (defaultMouseModeStr != null) {
                    this.mouseModeCapable.setMouseMode(Integer.parseInt(defaultMouseModeStr), 1024);
                }
                if ((defaultMouseModeStr = CvPropertiesManager.getProperty(modeProp = prefix + CvMouseControllerUtil.getMouseButtonDefaultConstant(2048) + ".aw")) != null) {
                    this.mouseModeCapable.setMouseMode(Integer.parseInt(defaultMouseModeStr), 2048);
                }
                if ((defaultMouseModeStr = CvPropertiesManager.getProperty(modeProp = prefix + CvMouseControllerUtil.getMouseButtonDefaultConstant(4096) + ".aw")) != null) {
                    this.mouseModeCapable.setMouseMode(Integer.parseInt(defaultMouseModeStr), 4096);
                }
            } else {
                this.getLogger().log(Level.INFO, "Viewport is not mouseModeCapable capable. so this action can not be performed on this viewport");
            }
        }
        catch (Exception exp) {
            this.getLogger().log(Level.WARNING, "Exception during mouse mode AW default settings operation, stack trace {0}", new Object[]{exp});
        }
    }
}

