/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.util.CvDSAImageUtils;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.jami.XpViewport;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;

public class XpMaskOnOffAction
extends BaseAction {
    private static final Logger logger = Logger.getLogger(XpMaskOnOffAction.class.getName());
    private static Icon applyMaskIcon = null;
    private static Icon unapplyMaskIcon = null;

    @Override
    protected String getName() {
        return "XP_MASK_ONOFF";
    }

    @Override
    protected void configure() {
        super.configure();
        applyMaskIcon = CvUtils.getIcon("XP_MASK_APPLY_ICON");
        unapplyMaskIcon = CvUtils.getIcon("XP_MASK_UNAPPLY_ICON");
        this.updateUI(true);
    }

    private void updateUI(boolean apply) {
        if (apply) {
            if (applyMaskIcon != null) {
                this.putValue("SmallIcon", applyMaskIcon);
            }
            if (CvUtils.getResourceBundle().getString("APPLY_MASK") != null) {
                this.setToolTip(CvUtils.getResourceBundle().getString("APPLY_MASK"));
            }
        } else {
            if (unapplyMaskIcon != null) {
                this.putValue("SmallIcon", unapplyMaskIcon);
            }
            if (CvUtils.getResourceBundle().getString("UNAPPLY_MASK") != null) {
                this.setToolTip(CvUtils.getResourceBundle().getString("UNAPPLY_MASK"));
            }
        }
    }

    @Override
    public void setEnabled(boolean enable) {
        XpViewport port;
        super.setEnabled(enable);
        if (enable && (port = this.findSelectedViewportByClass(XpViewport.class)) != null) {
            Object val = port.getClientProperty("mask_applied_property");
            boolean apply = val == null || !(val instanceof Boolean) || (Boolean)val == false;
            this.updateUI(apply);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        logger.log(Level.INFO, "XpMaskOnOffAction.actionPerformed()");
        if (this.getCapable() == null || CvUtils.isCinePlaying(this.getCapable())) {
            logger.log(Level.INFO, "XpMaskOnOffAction.actionPerformed() ..... no action, cine playing");
            return;
        }
        XpViewport port = this.findSelectedViewportByClass(XpViewport.class);
        if (port != null) {
            Object val = port.getClientProperty("mask_applied_property");
            if (val != null && val instanceof Boolean && ((Boolean)val).booleanValue()) {
                CvDSAImageUtils.unapplyMask(port);
                this.updateUI(true);
            } else {
                Object o = port.getClientProperty("manual_mask_index");
                if (o != null && o instanceof Integer) {
                    int idx = (Integer)o;
                    CvDSAImageUtils.applyFrameAsMask(port, idx);
                } else {
                    CvDSAImageUtils.applymask(port);
                }
                this.updateUI(false);
            }
        }
    }
}

