/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.idc.XpLinkPortCapable;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.CineCapable;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.terra.xpv.base.XPscreen;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;

public class XpLinkPortAction
extends BaseAction {
    private Icon link_icon = null;
    private Icon unlink_icon = null;
    private String link_tooltip = "Click to unlink ports";
    private String unlink_tooltip = "Click to link ports";
    transient PropertyChangeListener linkListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            XpLinkPortCapable lpcap = (XpLinkPortCapable)XpLinkPortAction.this.getCapable().getCapable(XpLinkPortCapable.class.getName());
            if (lpcap != null) {
                XpLinkPortAction.this.configure();
                if (lpcap.getPortsLinked()) {
                    XpLinkPortAction.this.setIcon(XpLinkPortAction.this.link_icon);
                    XpLinkPortAction.this.setToolTip(XpLinkPortAction.this.link_tooltip);
                    XpLinkPortAction.this.setSelected(true);
                } else {
                    XpLinkPortAction.this.setIcon(XpLinkPortAction.this.unlink_icon);
                    XpLinkPortAction.this.setToolTip(XpLinkPortAction.this.unlink_tooltip);
                    XpLinkPortAction.this.setSelected(false);
                }
            }
        }
    };
    transient PropertyChangeListener cineListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Capable cap = XpLinkPortAction.this.getCapable();
            XpLinkPortCapable lpc = (XpLinkPortCapable)cap.getCapable(XpLinkPortCapable.class.getName());
            if (lpc != null) {
                if (lpc instanceof CineCapable && ((CineCapable)((Object)lpc)).getCine()) {
                    XpLinkPortAction.this.setEnabled(false);
                } else {
                    XpLinkPortAction.this.setEnabled(true);
                }
            } else {
                XpLinkPortAction.this.setEnabled(false);
            }
        }
    };
    transient PropertyChangeListener portChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            XpLinkPortAction.this.updateState();
        }
    };

    @Override
    protected void configure() {
        this.link_icon = CvUtils.getIcon("XP_LINK_PORT_ICON");
        this.unlink_icon = CvUtils.getIcon("XP_UNLINK_PORT_ICON");
        this.link_tooltip = this.getI18NString("XP_LINK_PORT_TOOLTIP");
        this.unlink_tooltip = this.getI18NString("XP_UNLINK_PORT_TOOLTIP");
        this.setToolTip(this.unlink_tooltip);
        this.setIcon(this.unlink_icon);
    }

    @Override
    protected String getName() {
        return "XP_LINK_PORT";
    }

    @Override
    public void setCapable(Capable cap) {
        if (this.getCapable() != null) {
            this.getCapable().removePropertyChangeListener("link_ports", this.linkListener);
            this.getCapable().removePropertyChangeListener("port_change_property", this.portChangeListener);
            this.getCapable().removePropertyChangeListener("Cine", this.cineListener);
        }
        super.setCapable(cap);
        this.getCapable().addPropertyChangeListener("link_ports", this.linkListener);
        this.getCapable().addPropertyChangeListener("port_change_property", this.portChangeListener);
        this.getCapable().addPropertyChangeListener("Cine", this.cineListener);
        this.updateState();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        XpLinkPortCapable lpcap;
        if (this.getCapable() != null && (lpcap = (XpLinkPortCapable)this.getCapable().getCapable(XpLinkPortCapable.class.getName())) != null) {
            lpcap.setPortsLinked(!lpcap.getPortsLinked());
        }
    }

    private void updateState() {
        Capable cap = this.getCapable();
        XpLinkPortCapable lpc = (XpLinkPortCapable)cap.getCapable(XpLinkPortCapable.class.getName());
        if (lpc != null) {
            if (cap instanceof XPscreen) {
                int capablePortCount = 0;
                JComponent[] ports = ((XPscreen)cap).getAllPorts();
                for (int i = 0; i < ports.length; ++i) {
                    if (!(ports[i] instanceof Capable)) continue;
                    ++capablePortCount;
                }
                if (capablePortCount > 1) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
            } else if (lpc != null && lpc instanceof SelectionCapable && ((SelectionCapable)((Object)lpc)).getNumComponents() > 1) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        } else {
            this.setEnabled(false);
        }
    }
}

