/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.cpanels.XPDisplayPrefsUtils;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.jami.capable.AnnotCapable;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import javax.swing.JComponent;

public class XpFilmAnnotGroupAction
extends BaseAction {
    @Override
    protected String getName() {
        return "XP_FILM_ANN_GROUP";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block18: {
            TransactionLogName tln = new TransactionLogName("TID=CV_filmannotationGroup_custom");
            try {
                String[] params = this.getParams();
                AnnotCapable annotCap = this.getAnnotCapable();
                if (params != null) {
                    int length = params.length;
                    if (length < 2) {
                        this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INSUFF_PARAM"));
                        this.getLogger().log(Level.WARNING, "Missing some argument");
                        break block18;
                    }
                    if (length > 2) {
                        this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("TOO_MANY_PARAM"));
                        this.getLogger().log(Level.WARNING, "Too many argument");
                        break block18;
                    }
                    String imgType = CvUtils.getImageTypeKey(annotCap);
                    if (imgType == null) {
                        this.getLogger().log(Level.WARNING, "{0} SEV5 image type could not be evaluated", tln);
                        return;
                    }
                    boolean onoff = false;
                    if (params[0].equalsIgnoreCase("on")) {
                        onoff = true;
                    } else if (params[0].equalsIgnoreCase("off")) {
                        onoff = false;
                    } else {
                        this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
                        this.getLogger().log(Level.WARNING, "{0} SEV5 Invalid argument", tln);
                        return;
                    }
                    int index = 0;
                    try {
                        index = Integer.parseInt(params[1]);
                    }
                    catch (NumberFormatException nfe) {
                        if (params[1] != null && !params[1].equals("")) {
                            if (params[1].equalsIgnoreCase("w")) {
                                index = this.getIndex("Windowing", annotCap, imgType);
                            } else if (params[1].equalsIgnoreCase("g")) {
                                index = this.getIndex("Graphic_Results", annotCap, imgType);
                            } else {
                                this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
                                this.getLogger().log(Level.WARNING, "{0} Invalid argument list :" + nfe.getLocalizedMessage(), tln);
                            }
                        }
                        this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
                        this.getLogger().log(Level.WARNING, "{0} Invalid argument list :" + nfe.getLocalizedMessage(), tln);
                    }
                    String[] groups = XPDisplayPrefsUtils.getCustomAnnotationGroups(annotCap, imgType);
                    if (groups == null || index < 1 || index > groups.length) {
                        this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
                        this.getLogger().log(Level.WARNING, "{0} SEV5 NULL Custom groups", tln);
                        return;
                    }
                    int mask = XPDisplayPrefsUtils.getFilmCustomAnnotationLevel();
                    mask = onoff ? (mask |= XPDisplayPrefsUtils.getCustomAnnotationGroupMask(index - 1)) : (mask &= ~XPDisplayPrefsUtils.getCustomAnnotationGroupMask(index - 1));
                    XPDisplayPrefsUtils.updateFilmCustomAnnotationLevel(mask);
                    ((JComponent)((Object)annotCap)).putClientProperty("film_custom_annotation_level", new Integer(mask));
                    break block18;
                }
                this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INSUFF_PARAM"));
                this.getLogger().log(Level.WARNING, "Argument missing");
            }
            catch (Exception ex) {
                this.getLogger().log(Level.WARNING, "Invalid argument", ex);
            }
        }
    }

    private int getIndex(String gname, AnnotCapable acap, String imgType) {
        String[] groupElemts = XPDisplayPrefsUtils.getCustomAnnotationGroups(acap, imgType);
        if (groupElemts != null) {
            int eleLength = groupElemts.length;
            for (int i = 0; i < eleLength; ++i) {
                if (!groupElemts[i].equalsIgnoreCase(gname)) continue;
                return i + 1;
            }
        }
        return 0;
    }
}

