/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class XpExportScreenAction
extends BaseAction {
    private static final long serialVersionUID = 1L;
    private static final TransactionLogName tln = new TransactionLogName("TID=CV_exportScreenAction");

    @Override
    protected String getName() {
        return "XP_EXPORT_SCREEN";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFrame parent = null;
        if (e.getSource() instanceof AbstractButton) {
            Container parentComp = ((AbstractButton)e.getSource()).getParent();
            if (parentComp instanceof JPopupMenu) {
                JPopupMenu popup = (JPopupMenu)parentComp;
                parent = (JFrame)SwingUtilities.getWindowAncestor(popup.getInvoker());
            } else {
                parent = (JFrame)SwingUtilities.getWindowAncestor((JComponent)e.getSource());
            }
        }
        try {
            String finalpath = CvUtils.getPathToSave(parent);
            if (finalpath != null) {
                XPscreen saveFrame = (XPscreen)this.getCapable();
                BufferedImage viewerImage = new BufferedImage(saveFrame.getWidth(), saveFrame.getHeight(), 5);
                saveFrame.paint(viewerImage.getGraphics());
                if (finalpath.endsWith(".jpg") || finalpath.endsWith(".jpeg")) {
                    ImageIO.write((RenderedImage)viewerImage, "jpeg", new File(finalpath));
                } else if (finalpath.endsWith(".png")) {
                    ImageIO.write((RenderedImage)viewerImage, "png", new File(finalpath));
                } else {
                    finalpath = finalpath + ".jpeg";
                    ImageIO.write((RenderedImage)viewerImage, "jpeg", new File(finalpath));
                }
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(parent, CvUtils.getResourceBundle().getString("ERROR_FAILED_TO_EXPORT"), CvUtils.getResourceBundle().getString("MEDIA_VIEWER_TITLE"), 0);
            ex.printStackTrace();
        }
    }
}

