/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.roi.CvImageGrid;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpUserAnnotationModel;
import com.ge.med.terra.jami.capable.ROICapable;
import com.ge.med.terra.jami.capable.UserAnnoCapable;
import java.awt.event.ActionEvent;
import java.util.logging.Level;

public class XpEraseSelected
extends BaseAction {
    @Override
    protected String getName() {
        return "XP_ERASE_SELECTED";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String[] params = this.getParams();
        try {
            Object ob = null;
            if (params != null && params.length > 0) {
                this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
                this.setParams(null);
            } else {
                this.eraseROI();
                this.eraseUA();
                this.getCapable().repaint();
            }
        }
        catch (Exception exp) {
            this.getLogger().log(Level.WARNING, "Exception during erase selected graphics, {0}", exp);
        }
    }

    protected void eraseROI() {
        ROICapable roicap = this.getROICapable();
        if (roicap != null) {
            RoiActor[] rois = roicap.getRois().toArray(new RoiActor[0]);
            for (int i = 0; i < rois.length; ++i) {
                if (rois[i] instanceof CvImageGrid || !rois[i].isSelected()) continue;
                roicap.remove(rois[i]);
                this.getLogger().log(Level.FINE, "Removed the roi {0} sucessfully from the view port", rois[i]);
            }
        }
    }

    protected void eraseUA() {
        UserAnnoCapable userannocap = this.getUserAnnotationCapable();
        if (userannocap != null) {
            XpUserAnnotationModel[] uams = userannocap.getUserAnnos().toArray(new XpUserAnnotationModel[0]);
            for (int i = 0; i < uams.length; ++i) {
                if (!uams[i].isSelected()) continue;
                userannocap.remove(uams[i]);
                this.getLogger().log(Level.FINE, "Removed the userannotation {0} sucessfully from the view port", uams[i]);
            }
        }
    }
}

