/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.action.XpCineAction;
import com.ge.med.cse.cvf.appframework.ApplicationContext;
import com.ge.med.cse.cvf.appframework.ContextProvider;
import com.ge.med.cse.cvf.appframework.DataContext;
import com.ge.med.cse.cvf.dataloader.DatasetModel;
import com.ge.med.cse.cvf.dataloader.adv.XpBlankImageLoader;
import com.ge.med.cse.cvf.dataloader.adv.XpReplaceImageLoader;
import com.ge.med.cse.cvf.util.CvDSAImageUtils;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.idc.TaskMonitor;
import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.jami.platform.dm.XpMedicalDmImage;
import com.ge.med.terra.tap.dm.DMComposite;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import com.ge.med.terra.xpv.base.XPscreen;
import java.awt.Component;
import java.awt.Cursor;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class XpCineOnOffAction
extends XpCineAction {
    public static final String SCREEN_MULTIFRAME_CINE = "MultiframeCine";
    private XpReplaceImageLoader repLoader = new XpReplaceImageLoader();
    private String prevScreenName = null;
    private boolean status = false;

    public XpCineOnOffAction() {
        if (CvUtils.getResourceBundle().getString("XP_CINE_TOOLTIP") != null) {
            this.setToolTip(CvUtils.getResourceBundle().getString("XP_CINE_TOOLTIP"));
        }
    }

    @Override
    protected boolean startCine() {
        XpImage xi;
        this.prevScreenName = null;
        this.status = false;
        boolean loadcineport = false;
        DMComposite dmComp = null;
        JComponent origport = this.getSelectedViewport();
        XpCompositePort cport = (XpCompositePort)(origport.getParent() instanceof XpCompositePort ? origport.getParent() : null);
        if (origport != null && origport instanceof FrameOwner && (xi = ((FrameOwner)((Object)origport)).getFrame()) instanceof XpMedicalDmImage) {
            int numFrms;
            DMImage dmImg = ((XpMedicalDmImage)xi).getDMImage();
            String selimguid = (String)dmImg.getValue(DicomUtils.SOPInstanceUID[0], DicomUtils.SOPInstanceUID[1]);
            dmComp = dmImg.getComposite();
            if (dmComp != null && (numFrms = CvDSAImageUtils.getNumFrames(dmComp)) > 1) {
                loadcineport = true;
                if (cport != null && cport.getNumFrames() == numFrms) {
                    XpImage fr0 = cport.getFrame(0);
                    XpImage frsel = cport.getFrame(cport.getFrameIndex());
                    XpImage frN = cport.getFrame(cport.getNumFrames() - 1);
                    String uid0 = null;
                    String uidsel = null;
                    String uidN = null;
                    XpDicomElement sopinstanceuid = new XpDicomElement(DicomUtils.SOPInstanceUID[0], DicomUtils.SOPInstanceUID[1]);
                    if (fr0 instanceof XpDicomObject) {
                        ((XpDicomObject)((Object)fr0)).getValue(sopinstanceuid);
                        uid0 = sopinstanceuid.getStringValue();
                    }
                    if (frsel instanceof XpDicomObject) {
                        ((XpDicomObject)((Object)frsel)).getValue(sopinstanceuid);
                        uidsel = sopinstanceuid.getStringValue();
                    }
                    if (frN instanceof XpDicomObject) {
                        ((XpDicomObject)((Object)frN)).getValue(sopinstanceuid);
                        uidN = sopinstanceuid.getStringValue();
                    }
                    if (uid0 == selimguid && uidsel == selimguid && uidN == selimguid) {
                        loadcineport = false;
                    }
                }
            }
        }
        this.status = loadcineport ? this.loadCinePort(cport, dmComp) : super.startCine();
        if (CvUtils.getResourceBundle().getString("XP_CINE_OFF_TOOLTIP") != null && this.status) {
            this.setToolTip(CvUtils.getResourceBundle().getString("XP_CINE_OFF_TOOLTIP"));
        }
        return this.status;
    }

    protected boolean loadCinePort(final XpViewport selectedPort, final DMComposite multiFrameComposite) {
        if (selectedPort == null || multiFrameComposite == null) {
            return false;
        }
        final ApplicationContext appContext = ContextProvider.getApplicationContext(System.getProperty("APP_IDENTIFIER"));
        if (appContext != null) {
            this.prevScreenName = appContext.getCurrentScreen();
            appContext.setCurrentScreen(SCREEN_MULTIFRAME_CINE);
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    final JFrame parent = (JFrame)SwingUtilities.getWindowAncestor((JComponent)((Object)XpCineOnOffAction.this.getCapable()));
                    if (parent != null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Cursor cursor = new Cursor(3);
                                ((Component)parent).setCursor(cursor);
                            }
                        });
                        final XpViewport cineport = XpCineOnOffAction.this.findSelectedViewportByClass(XpViewport.class);
                        DataContext dataContext = ContextProvider.getDataContext(System.getProperty("APP_IDENTIFIER"));
                        DatasetModel model = dataContext.getDatasetModel("DATASET_2D_1");
                        DMTagValueInterface[] imgs = new DMTagValueInterface[]{multiFrameComposite};
                        String str = model.getDataset().getDataSetValidator().validateImages(imgs);
                        if ("SUPPORTED_MODALITY".equals(str)) {
                            XpBlankImageLoader blankloader = new XpBlankImageLoader();
                            model.getDataset().setData(multiFrameComposite);
                            TaskMonitor taskMo = appContext.getApplication().getDataLoadingMonitor();
                            blankloader.load(cineport, model, CvPropertiesManager.getProperties(), taskMo);
                            XpCineOnOffAction.this.repLoader.load(cineport, model, CvPropertiesManager.getProperties(), taskMo);
                            if (SwingUtilities.isEventDispatchThread()) {
                                Thread thread = new Thread(new Runnable(){

                                    @Override
                                    public void run() {
                                        XpCineOnOffAction.this.repLoader.run();
                                    }
                                });
                                thread.start();
                            } else {
                                XpCineOnOffAction.this.repLoader.run();
                            }
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (selectedPort != null && cineport instanceof XpCompositePort) {
                                    CvUtils.copyState(selectedPort, cineport, true);
                                }
                                if (CvDSAImageUtils.isRecommendedViewingModeSUB(multiFrameComposite)) {
                                    CvDSAImageUtils.applymask(cineport);
                                }
                                Cursor cursor = new Cursor(0);
                                ((Component)parent).setCursor(cursor);
                                XpCineOnOffAction.this.getCineCapable().setCine(true);
                                if (CvUtils.getResourceBundle().getString("XP_CINE_OFF_TOOLTIP") != null && XpCineOnOffAction.this.status) {
                                    XpCineOnOffAction.this.setToolTip(CvUtils.getResourceBundle().getString("XP_CINE_OFF_TOOLTIP"));
                                }
                            }
                        });
                    }
                }
            });
            thread.start();
            return true;
        }
        return false;
    }

    @Override
    protected void stopCine() {
        super.stopCine();
        if (this.prevScreenName != null) {
            ApplicationContext appContext;
            JComponent selcineport = this.getSelectedViewport();
            final XpViewport maincineport = this.findSelectedViewportByClass(XpViewport.class);
            if (selcineport != null && selcineport.getClientProperty("manual_mask_index") != null) {
                selcineport.putClientProperty("manual_mask_index", null);
            }
            if (maincineport != null) {
                CvDSAImageUtils.unapplyMask(maincineport);
            }
            if ((appContext = ContextProvider.getApplicationContext(System.getProperty("APP_IDENTIFIER"))) != null) {
                appContext.setCurrentScreen(this.prevScreenName);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (maincineport != null) {
                        if (XpCineOnOffAction.this.getCapable() instanceof XPscreen) {
                            XPscreen scr = (XPscreen)XpCineOnOffAction.this.getCapable();
                            for (int i = 0; i < scr.getNumPorts(); ++i) {
                                JComponent port = scr.getPort(i);
                                if (!(port instanceof XpViewport)) continue;
                                CvUtils.copyState(maincineport, (XpViewport)port, true);
                            }
                        } else {
                            XpViewport destport = XpCineOnOffAction.this.findSelectedViewportByClass(XpViewport.class);
                            CvUtils.copyState(maincineport, destport, true);
                        }
                    }
                }
            });
        }
        if (CvUtils.getResourceBundle().getString("XP_CINE_TOOLTIP") != null) {
            this.setToolTip(CvUtils.getResourceBundle().getString("XP_CINE_TOOLTIP"));
        }
    }
}

