/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.log.CvGESyslogMessageCode;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.print.PrinterStatus;
import com.ge.med.cse.cvf.print.XpPrintJobListener;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.CineCapable;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.Doc;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.attribute.PrintRequestAttributeSet;

public class XpBaseFilmAction
extends BaseAction {
    protected static final Logger logger = Logger.getLogger(XpBaseFilmAction.class.getName());
    protected PrintService service_ = null;
    protected DocPrintJob job = null;
    protected Doc doc = null;
    protected TransactionLogName tln = null;
    protected boolean useCapable = true;

    @Override
    protected String getName() {
        return "XP_BASE_FILM";
    }

    public boolean init() {
        CineCapable cc;
        if (this.useCapable && (cc = (CineCapable)this.getCapable().getCapable(CineCapable.class.getName())) != null && cc.getCine()) {
            logger.log(Level.INFO, "F1 Film action failed as Cine is On.", this.tln);
            return false;
        }
        this.service_ = CvUtils.getDefaultPrintService();
        if (this.service_ == null) {
            String error = CvUtils.getResourceBundle().getString("FC_NOT_RUN");
            logger.log(UserMessageLevel.USER_MSG, error);
            logger.log(Level.INFO, "{0} Sev5 No print services found !!", this.tln);
            logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_ERROR, error});
            return false;
        }
        PrinterStatus attr = this.service_.getAttribute(PrinterStatus.class);
        boolean status = false;
        if (attr != null) {
            status = this.service_.getAttribute(PrinterStatus.class).getValue();
        }
        if (attr == null && !status) {
            String error = CvUtils.getResourceBundle().getString("FC_NOT_RUN");
            logger.log(UserMessageLevel.USER_MSG, error);
            logger.log(Level.INFO, "{0} Sev5 Error in printing : Film Composer may not be running", this.tln);
            logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_ERROR, error});
            return false;
        }
        this.job = this.service_.createPrintJob();
        if (this.job == null) {
            String error = CvUtils.getResourceBundle().getString("FC_NULL_JOB");
            logger.log(UserMessageLevel.USER_MSG, error);
            logger.log(Level.INFO, "{0} Sev5 Error in printing : NULL Dicom Print Job", this.tln);
            logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_ERROR, error});
            return false;
        }
        if (CvUtils.isFilmPrintingInProgress(this.job)) {
            logger.log(Level.WARNING, "{0} Printing already in Progress", this.tln);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doPrint(PrintRequestAttributeSet aset) {
        if (this.doc == null) {
            String error = CvUtils.getResourceBundle().getString("FC_NULL_JOB");
            logger.log(UserMessageLevel.USER_MSG, error);
            logger.log(Level.SEVERE, "{0} Sev5 Error in printing : NULL Dicom Print doc", this.tln);
            logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_ERROR, error});
            return false;
        }
        XpPrintJobListener lsnr = new XpPrintJobListener(this.doc);
        try {
            this.job.addPrintJobListener(lsnr);
            this.job.print(this.doc, aset);
        }
        catch (PrintException pe) {
            logger.log(UserMessageLevel.USER_MSG, pe.getLocalizedMessage());
            logger.log(Level.SEVERE, "{0} Error in printing due to " + pe.getLocalizedMessage(), this.tln);
            logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_ERROR, pe.getLocalizedMessage()});
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public void setTransactionLogName(TransactionLogName tln) {
        this.tln = tln;
    }

    public void setDoc(Doc doc) {
        this.doc = doc;
    }

    public void setUseCapable(boolean useCap) {
        this.useCapable = useCap;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }
}

