/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.model.WWWLModel;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.WindowLevelCapable;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class XpAbstractPresetSaveAction
extends BaseAction {
    protected Capable cap_;
    private String strFuncKey = "";
    private static final Logger logger_ = Logger.getLogger(XpAbstractPresetSaveAction.class.getName());

    public XpAbstractPresetSaveAction(String strFncKey) {
        this.strFuncKey = strFncKey;
    }

    @Override
    public void setCapable(Capable s) {
        this.cap_ = s;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String modality = CvUtils.getCurrentModality(this.cap_);
        WWWLModel model = WWWLModel.getModel(modality);
        if (model.getModality().equalsIgnoreCase(modality)) {
            WindowLevelCapable wlc = (WindowLevelCapable)this.cap_.getCapable(WindowLevelCapable.class.getName());
            if (wlc != null) {
                double WW = wlc.getWinMax() - wlc.getWinMin();
                double WL2 = (wlc.getWinMax() + wlc.getWinMin()) / 2.0;
                model.setWWWL(model.getPresetForKey(this.strFuncKey), new double[]{WW, WL2});
            } else {
                logger_.log(Level.INFO, "Viewport is not window level capable. so this action can not be performed on this viewport");
            }
        }
    }

    public static class F11
    extends XpAbstractPresetSaveAction {
        public F11() {
            super("F11");
        }

        @Override
        protected String getName() {
            return "F11";
        }
    }

    public static class F10
    extends XpAbstractPresetSaveAction {
        public F10() {
            super("F10");
        }

        @Override
        protected String getName() {
            return "F10";
        }
    }

    public static class F9
    extends XpAbstractPresetSaveAction {
        public F9() {
            super("F9");
        }

        @Override
        protected String getName() {
            return "F9";
        }
    }

    public static class F8
    extends XpAbstractPresetSaveAction {
        public F8() {
            super("F8");
        }

        @Override
        protected String getName() {
            return "F8";
        }
    }

    public static class F7
    extends XpAbstractPresetSaveAction {
        public F7() {
            super("F7");
        }

        @Override
        protected String getName() {
            return "F7";
        }
    }

    public static class F6
    extends XpAbstractPresetSaveAction {
        public F6() {
            super("F6");
        }

        @Override
        protected String getName() {
            return "F6";
        }
    }
}

