/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.aac;

import com.ge.med.cse.cvf.base.CvImageLoader;
import com.ge.med.cse.cvf.idc.PagingCapable;
import com.ge.med.cse.cvf.idc.XpLinkPortCapable;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.util.CPIUtils;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.CineCapable;
import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.xpv.ui.ActiveAnnotationControl;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class XpSeriesPagingActiveAnnotation
implements ActiveAnnotationControl {
    private static final Logger logger = Logger.getLogger(XpSeriesPagingActiveAnnotation.class.getName());
    private Thread loaderThread = null;
    private Capable compcap = null;
    private static final XpDicomElement eid = new XpDicomElement(32, 16);
    private static final XpDicomElement euid = new XpDicomElement(32, 13);
    private static final XpDicomElement suid = new XpDicomElement(32, 14);

    @Override
    public String getShortDescription() {
        return CvUtils.getResourceBundle().getString("AA_SERIES_TOOLTIP");
    }

    @Override
    public void listenTo(Component c) {
        if (c instanceof Capable) {
            this.setCapable((Capable)((Object)c));
        }
    }

    @Override
    public void setCapable(Capable cap) {
        this.compcap = cap;
        if (!(cap instanceof JComponent)) {
            this.compcap = cap.getCapable(PagingCapable.class.getName());
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int modifiers = e.getModifiers();
        int mbutton1 = modifiers & 0x10;
        int mbutton3 = modifiers & 4;
        if (mbutton1 != 0 || mbutton3 != 0) {
            Component o = (Component)e.getSource();
            if (!(o instanceof XpCompositePort)) {
                o = SwingUtilities.getAncestorOfClass(XpCompositePort.class, o);
            }
            if (!(o instanceof XpCompositePort) || o instanceof CineCapable && ((CineCapable)((Object)o)).getCine()) {
                return;
            }
            Container c = SwingUtilities.getAncestorOfClass(XpLinkPortCapable.class, o);
            if (c != null && ((XpLinkPortCapable)((Object)c)).getPortsLinked()) {
                logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("UNLINK_PORT_TOLOAD_EXAM"));
                return;
            }
            final boolean prev = mbutton3 != 0;
            final XpCompositePort port = (XpCompositePort)o;
            this.loaderThread = new Thread(){

                @Override
                public void run() {
                    DMObject[] objs;
                    XpMedicalImage image = (XpMedicalImage)port.getFrame();
                    if (image == null) {
                        logger.info("Selected port in empty");
                        return;
                    }
                    DMSession sess = CvUtils.getDMSystem().getLocalDB();
                    if (sess == null) {
                        logger.info("No DMSystem found");
                        return;
                    }
                    image.getValue(eid);
                    image.getValue(euid);
                    image.getValue(suid);
                    String query = "(0x0020, 0x000D) = " + euid.getStringValue();
                    if (eid.getStringValue() != null && eid.getStringValue().trim().length() > 0) {
                        query = query + " AND (0x0020, 0x0010) = " + eid.getStringValue();
                    }
                    if ((objs = sess.getRelated("series", new DMQuery(query = query + " AND (0x0020, 0x000E) = " + suid.getStringValue()))) == null || objs.length == 0) {
                        logger.info("Current series query returned null, query : " + query);
                        return;
                    }
                    DMObject current = objs[0];
                    DMObject sel = null;
                    do {
                        DMObject next;
                        if ((next = CvUtils.getDMSystem().getNextInBrowser(current, prev)) == null) continue;
                        if (next.equals(current)) break;
                        if (CvImageLoader.getInstance().isValid(new DMObject[]{next}) && !CPIUtils.isGSPS(next)) {
                            sel = next;
                        }
                        current = next;
                    } while (sel == null && !objs[0].equals(current));
                    if (sel != null) {
                        CvUtils.getDMSystem().setSelection(new DMObject[]{sel});
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    CvImageLoader.getInstance().loadData(true);
                                }
                            });
                        }
                        catch (InterruptedException e) {
                            logger.info("Loading in normal way in thread");
                            CvImageLoader.getInstance().loadData(true);
                        }
                        catch (InvocationTargetException e) {
                            logger.info("Loading in normal way in thread");
                            CvImageLoader.getInstance().loadData(true);
                        }
                    }
                }
            };
            if (this.compcap != null && ((PagingCapable)this.compcap).isPagingOn()) {
                this.loaderThread.setName("ImageLoader_SeriesActiveAnnotation");
                this.loaderThread.start();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }
}

