/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.aac;

import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.PanZoomCapable;
import com.ge.med.terra.xpv.ui.ActiveAnnotationControl;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public class CVAAZoomOnClick
implements ActiveAnnotationControl {
    private int ZOOM = Integer.parseInt(CvPropertiesManager.getProperty("cvf.zoomfactor", "2"));
    protected PanZoomCapable zoomCap = null;

    @Override
    public String getShortDescription() {
        return "Adjust Magnification";
    }

    @Override
    public void listenTo(Component c) {
        if (c instanceof Capable) {
            this.setCapable((Capable)((Object)c));
        }
    }

    @Override
    public void setCapable(Capable capable) {
        this.zoomCap = (PanZoomCapable)capable.getCapable(PanZoomCapable.class.getName());
    }

    protected void setZoom(double zoom) {
        if (this.zoomCap != null) {
            this.zoomCap.setZoom(zoom);
            this.zoomCap.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.zoomCap == null) {
            this.zoomCap = (PanZoomCapable)((Object)SwingUtilities.getAncestorOfClass(PanZoomCapable.class, e.getComponent()));
        }
        if (e.getButton() == 1) {
            this.setZoom(Math.min(this.zoomCap.getZoom() * (double)this.ZOOM, CvUtils.getMaxZoom()));
        } else if (e.getButton() == 3) {
            this.setZoom(Math.max(this.zoomCap.getZoom() / (double)this.ZOOM, CvUtils.getMinZoom()));
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

