/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.aac;

import com.ge.med.cse.cvf.action.XpWindowPresetAction;
import com.ge.med.cse.cvf.model.WWWLModel;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.xpv.ui.ActiveAnnotationControl;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class CVAAWWWL
implements ActiveAnnotationControl,
ActionListener {
    private static final Logger logger = Logger.getLogger(CVAAWWWL.class.getName());
    private static JPopupMenu popup = new JPopupMenu("Presets");
    private String modality;
    private WWWLModel wwlookup;
    private XpWindowPresetAction action;
    private Capable capable;

    public CVAAWWWL() {
        popup.setName("presetPopUp");
        this.action = new XpWindowPresetAction();
    }

    private void updatePresets() {
        popup.removeAll();
        String[] presets = this.wwlookup.getPresets();
        for (int i = 0; i < presets.length; ++i) {
            JMenuItem menu = new JMenuItem();
            popup.add(menu);
            String key = this.wwlookup.getShortCutKey(presets[i]);
            menu.setText(this.wwlookup.getTitle(presets[i]) + " (" + key + ")");
            menu.setActionCommand(presets[i]);
            menu.addActionListener(this);
            popup.setFocusable(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        this.action.setPreset(cmd);
        this.action.actionPerformed(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 3) {
            if (this.capable == null) {
                XpViewport viewport = (XpViewport)SwingUtilities.getAncestorOfClass(XpViewport.class, e.getComponent());
                if (viewport == null || !(viewport instanceof Capable)) {
                    return;
                }
                this.capable = viewport;
            }
            if (this.capable == null) {
                logger.log(Level.WARNING, "Port is null");
                return;
            }
            if (CvUtils.isCinePlaying(this.capable)) {
                logger.log(Level.WARNING, "Cine is running");
                return;
            }
            this.modality = CvUtils.getCurrentModality(this.capable);
            if (this.modality != null) {
                this.wwlookup = WWWLModel.getModel(this.modality);
            }
            this.updatePresets();
            this.action.setCapable(this.capable);
            if (!popup.isVisible()) {
                popup.show(e.getComponent(), e.getX(), e.getY());
            } else {
                popup.setLocation(e.getX(), e.getY());
            }
        }
    }

    @Override
    public String getShortDescription() {
        return CvUtils.getResourceBundle().getString("AA_WL_TOOLTIP");
    }

    @Override
    public void setCapable(Capable capable) {
        this.capable = capable;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void listenTo(Component c) {
    }
}

