/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.apps.cdviewer.ui;

import com.ge.med.cse.cvf.controls.CvMouseController;
import com.ge.med.cse.cvf.controls.CvMouseControllerUtil;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;

public class MouseMenuToolBarController
implements ActionListener {
    private HashMap<String, Integer> mouseActionCmds = new HashMap();
    final int ICON_SIZE = 20;
    List<JButton> mouseMenuOptions = new ArrayList<JButton>();
    CvMouseController cvMouseController = null;
    private int currentSelectedMode = -1;
    private HashMap<Integer, JButton> mouseControllers = new HashMap();
    PropertyChangeListener mouseModeChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Integer[] newValue = (Integer[])evt.getNewValue();
            if (newValue.length == 2) {
                int newMode = newValue[0];
                if (MouseMenuToolBarController.this.currentSelectedMode != newMode) {
                    if (MouseMenuToolBarController.this.mouseControllers.get(MouseMenuToolBarController.this.currentSelectedMode) != null) {
                        ((JButton)MouseMenuToolBarController.this.mouseControllers.get(MouseMenuToolBarController.this.currentSelectedMode)).setSelected(false);
                    }
                    MouseMenuToolBarController.this.currentSelectedMode = newMode;
                    if (MouseMenuToolBarController.this.mouseControllers.get(newMode) != null) {
                        ((JButton)MouseMenuToolBarController.this.mouseControllers.get(newMode)).setSelected(true);
                    }
                }
            }
        }
    };

    public MouseMenuToolBarController(CvMouseController cvMouseController) {
        this.cvMouseController = cvMouseController;
        try {
            cvMouseController.addPropertyChangeListener(this.mouseModeChangeListener);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.createController();
    }

    public void createController() {
        int[] modes;
        for (int mode : modes = this.cvMouseController.getSupportedModes()) {
            JButton btn = new JButton();
            btn.addActionListener(this);
            btn.setIcon((Icon)this.cvMouseController.getModeProperty(mode, "icon_property"));
            btn.setToolTipText((String)this.cvMouseController.getModeProperty(mode, "name_property"));
            btn.setActionCommand((String)this.cvMouseController.getModeProperty(mode, "name_property"));
            btn.setName((String)this.cvMouseController.getModeProperty(mode, "name_property"));
            this.mouseControllers.put(mode, btn);
            this.mouseActionCmds.put(btn.getActionCommand(), mode);
            this.mouseMenuOptions.add(btn);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int newMode = this.mouseActionCmds.get(e.getActionCommand());
        if (newMode != -1 && this.currentSelectedMode != newMode) {
            if (this.mouseControllers.get(this.currentSelectedMode) != null) {
                this.mouseControllers.get(this.currentSelectedMode).setSelected(false);
            }
            this.currentSelectedMode = newMode;
            if (this.mouseControllers.get(newMode) != null) {
                this.mouseControllers.get(newMode).setSelected(true);
            }
            this.cvMouseController.removePropertyChangeListener(this.mouseModeChangeListener);
            this.cvMouseController.setMouseMode(newMode, CvMouseControllerUtil.getMouseModeToApplyButton(CvPropertiesManager.getProperties()));
            this.cvMouseController.addPropertyChangeListener(this.mouseModeChangeListener);
        }
    }

    public List<JButton> getMouseMenuOptions() {
        return this.mouseMenuOptions;
    }
}

