/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.apps.cdviewer.treetable;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class TreeTableCellRenderer
extends DefaultTableCellRenderer {
    public static ImageIcon lastSubItemIcon;
    public static ImageIcon midSubItemIcon;
    public static Icon sublistClosedIcon;
    public static Icon sublistOpenIcon;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (column > 0) {
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        if (value == null) {
            return this;
        }
        String text = (String)value;
        this.setText("");
        if (text.equals("+")) {
            this.setIcon(sublistClosedIcon);
        } else if (text.equals("-")) {
            this.setIcon(sublistOpenIcon);
        } else if (text.equals("|")) {
            this.setIcon(midSubItemIcon);
        } else if (text.equals("#")) {
            this.setIcon(lastSubItemIcon);
        } else {
            this.setIcon(null);
        }
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
        } else {
            Color foreground = table.getForeground();
            Color background = table.getBackground();
            if (row % 2 == 0) {
                this.setForeground(foreground);
                this.setBackground(background);
            } else {
                if (foreground != null) {
                    this.setForeground(foreground);
                }
                if (background != null) {
                    this.setBackground(background);
                }
            }
        }
        return this;
    }

    static {
        try {
            lastSubItemIcon = new ImageIcon(TreeTableCellRenderer.class.getResource("icons/treeBranchEnd.gif"));
            midSubItemIcon = new ImageIcon(TreeTableCellRenderer.class.getResource("icons/treeBranchBtw.gif"));
            if (sublistClosedIcon == null) {
                sublistClosedIcon = new ImageIcon(TreeTableCellRenderer.class.getResource("icons/subList-closed.gif"));
            }
            if (sublistOpenIcon == null) {
                sublistOpenIcon = new ImageIcon(TreeTableCellRenderer.class.getResource("icons/subList-open.gif"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

