/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.apps.cdviewer.tools.shrinker;

import com.ge.med.cse.apps.cdviewer.tools.shrinker.AntFileSetCreator;
import com.ge.med.cse.apps.cdviewer.tools.shrinker.ResourceFileSniffer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.instrument.Instrumentation;

public class ClassLoaderInstrument {
    private static Instrumentation delegate = null;
    private static String agentArgs = null;
    private static BufferedWriter writer = null;
    public static final File toDumpInfo = new File(System.getProperty("user.home") + File.separatorChar + "LoadedResources.txt");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void premain(String args, Instrumentation inst) {
        delegate = inst;
        agentArgs = args;
        FileWriter fw = null;
        try {
            fw = new FileWriter(toDumpInfo);
            writer = new BufferedWriter(fw);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    ClassLoaderInstrument.generateInfoFile();
                    try {
                        writer.close();
                        AntFileSetCreator.createAntFileSet();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fw != null) {
                    fw.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        ResourceFileSniffer.startSniff();
    }

    protected static void generateInfoFile() {
        try {
            Class[] loadedClasses = delegate.getAllLoadedClasses();
            for (int i = 0; i < loadedClasses.length; ++i) {
                if (!ClassLoaderInstrument.isValidClass(loadedClasses[i].getName())) continue;
                ClassLoaderInstrument.writeLine(loadedClasses[i].getName().trim());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void writeLine(String strToWrite) {
        try {
            writer.write(strToWrite);
            writer.newLine();
            writer.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static boolean isValidClass(String clsName) {
        return !clsName.startsWith("java") && !clsName.startsWith("sun") && !clsName.endsWith(";") && !clsName.startsWith("[");
    }
}

