/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.apps.cdviewer.lnf;

import com.ge.med.cse.cvf.laf.LookAndFeelFactory;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuBarUI;
import javax.swing.plaf.SliderUI;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.plaf.basic.BasicToolBarUI;
import javax.swing.plaf.basic.BasicTreeUI;

public class LookAndFeelUtil {
    private static String DEFAULT_PROP_FILE = "Default_LNFProps.properties";
    private static String LNFNAMELOOKUP_FILE = "LNFNameLookUp.properties";
    private static String DEFAULT_LNF_NAME = "defaultLNF";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setupLAF() {
        String LnFFilePropName;
        String defaultLaf;
        System.err.println("LAF set up ....");
        String lookAndFeel = defaultLaf = System.getProperty("swing.defaultlaf");
        if (defaultLaf == null) {
            lookAndFeel = CvPropertiesManager.getProperty("MediaViewer.lookandfeel");
            System.err.println("Look and Feel set to IUNGO HDx");
        }
        if (lookAndFeel != null && LookAndFeelFactory.setupLAFclass(lookAndFeel)) {
            System.err.println("Look and Feel set to " + lookAndFeel);
        }
        if (null != (LnFFilePropName = LookAndFeelUtil.getPropFileName())) {
            InputStream in = null;
            try {
                in = LookAndFeelUtil.class.getResourceAsStream(LnFFilePropName);
                LookAndFeelFactory.loadPropertyValues(in);
                LookAndFeelFactory.loadAndPopulate_LNFExtPropFile_Properties();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void apply_LnF_CSS_onComp(JComponent comp, String css_class) {
        String css_class_value = LookAndFeelFactory.getPropertyValue(css_class);
        if (css_class_value != null) {
            comp.putClientProperty("css_class", css_class_value);
        }
    }

    public static void set_LnF_UI_onTree(JTree comp, String hdx_class) {
        ComponentUI uiClass = LookAndFeelUtil.get_LnF_UI_class(comp, hdx_class);
        if (uiClass != null) {
            BasicTreeUI treeUI = (BasicTreeUI)uiClass;
            comp.setUI(treeUI);
        }
    }

    public static void set_LnF_UI_onLicense(JTextArea comp, String hdx_class) {
        ComponentUI uiClass = LookAndFeelUtil.get_LnF_UI_class(comp, hdx_class);
        if (uiClass != null) {
            BasicTextAreaUI licUI = (BasicTextAreaUI)uiClass;
            comp.setUI(licUI);
        }
    }

    public static void set_LnF_UI_onToolbar(JToolBar comp, String hdx_class) {
        ComponentUI uiClass = LookAndFeelUtil.get_LnF_UI_class(comp, hdx_class);
        if (uiClass != null) {
            BasicToolBarUI tbarUI = (BasicToolBarUI)uiClass;
            comp.setUI(tbarUI);
        }
    }

    public static void set_LnF_UI_onMenuBar(JMenuBar comp, String hdx_class) {
        ComponentUI uiClass = LookAndFeelUtil.get_LnF_UI_class(comp, hdx_class);
        if (uiClass != null) {
            MenuBarUI menuBarUI = (MenuBarUI)uiClass;
            comp.setUI(menuBarUI);
        }
    }

    public static void set_LnF_UI_onSlider(JSlider comp, String hdx_class) {
        ComponentUI uiClass = LookAndFeelUtil.get_LnF_UI_class(comp, hdx_class);
        if (uiClass != null) {
            SliderUI sliderUI = (SliderUI)uiClass;
            comp.setUI(sliderUI);
        }
    }

    public static void set_LnF_UI_onTable(JTable comp, String hdx_class) {
        ComponentUI uiClass = LookAndFeelUtil.get_LnF_UI_class(comp, hdx_class);
        if (uiClass != null) {
            TableUI tableUI = (TableUI)uiClass;
            comp.setUI(tableUI);
        }
    }

    public static ComponentUI get_LnF_UI_class(JComponent comp, String hdx_class) {
        ComponentUI uiClass = null;
        try {
            Class classobject = LookAndFeelFactory.getClass(hdx_class);
            if (classobject != null) {
                Method method = classobject.getMethod("createUI", JComponent.class);
                uiClass = (ComponentUI)method.invoke(null, comp);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return uiClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPropFileName() {
        String lnfClass = LookAndFeelUtil.getLnfClass();
        String lnfClassName = null;
        Properties lnfFileNameMap = new Properties();
        InputStream in = LookAndFeelUtil.class.getResourceAsStream(LNFNAMELOOKUP_FILE);
        if (null != in) {
            try {
                lnfFileNameMap.load(in);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (lnfFileNameMap.size() > 0) {
            lnfClassName = (String)lnfFileNameMap.get(lnfClass);
        }
        if (null != lnfClassName) {
            String lnfClassPropFileName = lnfClassName + "_props.properties";
            return lnfClassPropFileName;
        }
        return DEFAULT_PROP_FILE;
    }

    private static String getLnfClass() {
        if (null != UIManager.getLookAndFeel().getClass().getSimpleName()) {
            return UIManager.getLookAndFeel().getClass().getSimpleName();
        }
        return DEFAULT_LNF_NAME;
    }
}

