/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.apps.cdviewer.datasetloader;

import com.ge.med.cse.apps.cdviewer.lnf.LookAndFeelUtil;
import com.ge.med.cse.cvf.base.CvSeriesDisplayer;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.annotation.XpAnnotationModel;
import com.ge.med.terra.jami.annotation.XpAnnotationPolicy;
import com.ge.med.terra.jami.capable.FrameCapable;
import com.ge.med.terra.xpv.onport.XPopPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.BoundedRangeModel;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MediaViewerPopSlider
extends XPopPanel
implements ActionListener {
    public static final String NO_SKIP_MODE = "NO_SKIP_MODE";
    public static final String SCROLL_VALUE = "SCROLL_VALUE";
    public FramePositioningCapable port;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private boolean enabled = true;
    private Timer adjustScrollBar = new Timer(100, this);
    private JSlider frameCtl = new JSlider();
    private JLabel topLabel = new JLabel("");
    private JLabel bottomLabel = new JLabel("");
    private static XpDicomElement sopclassuid = new XpDicomElement(DicomUtils.SOPClassUID[0], DicomUtils.SOPClassUID[1]);
    private static XpDicomElement sopinstanceuid = new XpDicomElement(DicomUtils.SOPInstanceUID[0], DicomUtils.SOPInstanceUID[1]);
    private PropertyChangeListener viewPortListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == "FrameIndex") {
                MediaViewerPopSlider.this.updateSlider();
            }
        }
    };
    private String mlregex = "\\D*(ML|LM|SI|IS|AT)+\\D*";
    private String ccregex = "\\D*(CC|FB|CV)+\\D*";

    public MediaViewerPopSlider() {
        this.setName("MV_POP_SLIDER");
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.adjustScrollBar.setRepeats(false);
        this.setStayOnMouseEnter(true);
    }

    @Override
    protected void displayLevel(int level) {
        if (this.port != null) {
            boolean b = this.port.getNumFrames() > 1;
            this.setEnabled(b);
            super.displayLevel(b ? level : 0);
        } else {
            super.displayLevel(level);
        }
        int a = this.getLevel() > 0 ? 1 : 0;
        Color c = new Color(MediaViewerPopSlider.getBackGroundR(), MediaViewerPopSlider.getBackGroundG(), MediaViewerPopSlider.getBackGroundB(), a);
        this.setBackground(c);
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.frameCtl.setName("MV_Slider");
        this.frameCtl.setOrientation(1);
        this.frameCtl.setOpaque(false);
        LookAndFeelUtil.set_LnF_UI_onSlider(this.frameCtl, "slider.ui");
        this.topLabel.setName("MV_Slider_TopLabel");
        this.topLabel.setOpaque(false);
        this.topLabel.setHorizontalAlignment(4);
        this.topLabel.setForeground(Color.WHITE);
        this.bottomLabel.setName("MV_Slider_BottomLabel");
        this.bottomLabel.setOpaque(false);
        this.bottomLabel.setHorizontalAlignment(4);
        this.bottomLabel.setForeground(Color.WHITE);
        this.frameCtl.setBorder(new EmptyBorder(0, 0, 0, 5));
        this.add((Component)this.frameCtl, "East");
        this.add((Component)this.topLabel, "North");
        this.add((Component)this.bottomLabel, "South");
        this.setPreferredSize(new Dimension(30, 350));
        this.setMinimumSize(new Dimension(20, 150));
        this.setOpaque(false);
        this.frameCtl.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (e.getSource() == MediaViewerPopSlider.this.frameCtl) {
                    MediaViewerPopSlider.this.updatePort();
                }
            }
        });
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.enabled = enabled;
    }

    @Override
    public void fire() {
        if (this.enabled) {
            super.fire();
        }
    }

    @Override
    public final void removePropertyChangeListener(String propName, PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(propName, pcl);
    }

    @Override
    public final void addPropertyChangeListener(String propName, PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(propName, pcl);
    }

    @Override
    public void setCapable(final Capable capable) {
        if (capable instanceof FramePositioningCapable) {
            this.port = (FramePositioningCapable)capable;
            this.updateSlider();
            this.port.addPropertyChangeListener(this.viewPortListener);
        }
        capable.addPropertyChangeListener("CONTENT_CHANGED", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FramePositioningCapable frposCap = (FramePositioningCapable)capable.getCapable(FramePositioningCapable.class.getName());
                int totalFrame = frposCap.getNumFrames();
                BoundedRangeModel model = MediaViewerPopSlider.this.frameCtl.getModel();
                int newSliderValue = totalFrame;
                MediaViewerPopSlider.this.frameCtl.getModel().setRangeProperties(newSliderValue, 0, 1, totalFrame, model.getValueIsAdjusting());
                MediaViewerPopSlider.this.updateLabels();
                MediaViewerPopSlider.this.displayLevel(MediaViewerPopSlider.this.getLevel());
            }
        });
        capable.addPropertyChangeListener("CONTENT_UPDATED", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MediaViewerPopSlider.this.updateLabels();
                MediaViewerPopSlider.this.displayLevel(MediaViewerPopSlider.this.getLevel());
            }
        });
    }

    public void updateLabels() {
        FrameCapable fCap;
        if (!this.enabled) {
            return;
        }
        String top = " ";
        String bottom = " ";
        if (this.port != null && (fCap = (FrameCapable)((Object)this.port.getCapable(FrameCapable.class.getName()))) != null && fCap.getNumFrames() > 1 && fCap.getFrame(0) != null && fCap.getFrame(1) != null) {
            boolean showlabels = false;
            if (fCap.getFrame(0) instanceof XpDicomObject && fCap.getFrame(1) instanceof XpDicomObject) {
                XpDicomObject dmo0 = (XpDicomObject)((Object)fCap.getFrame(0));
                XpDicomObject dmo1 = (XpDicomObject)((Object)fCap.getFrame(1));
                dmo0.getValue(sopclassuid);
                if ("1.2.840.10008.5.1.4.1.1.13.1.3".equals(sopclassuid.getStringValue())) {
                    showlabels = true;
                }
                dmo0.getValue(sopinstanceuid);
                String uid0 = sopinstanceuid.getStringValue();
                dmo1.getValue(sopinstanceuid);
                String uid1 = sopinstanceuid.getStringValue();
                if (!uid0.equals(uid1)) {
                    showlabels = false;
                }
            }
            if (showlabels) {
                CPoint c0 = new CPoint(2);
                CPoint c1 = new CPoint(2);
                fCap.getFrame(0).getSlice().getSliceCenter(c0);
                fCap.getFrame(1).getSlice().getSliceCenter(c1);
                JnVector3d dirv = new JnVector3d(c1.x - c0.x, c1.y - c0.y, c1.z - c0.z);
                dirv.normalize();
                XpImage img = fCap.getFrame(0);
                if (img instanceof XpDicomObject) {
                    String clinicalViewName = DicomUtils.getClinicalViewName((XpDicomObject)((Object)img));
                    String viewName = clinicalViewName.substring(1, clinicalViewName.length());
                    if (viewName.matches(this.mlregex)) {
                        double x;
                        String lat = DicomUtils.getLaterality((XpDicomObject)((Object)img));
                        double d = x = "L".equalsIgnoreCase(lat) ? -dirv.x : dirv.x;
                        if (x > 0.0) {
                            top = "M";
                            bottom = "L";
                        } else {
                            top = "L";
                            bottom = "M";
                        }
                    } else if (viewName.matches(this.ccregex)) {
                        if (dirv.z > 0.0) {
                            top = "I";
                            bottom = "S";
                        } else {
                            top = "S";
                            bottom = "I";
                        }
                    }
                }
            }
        }
        Font afont = null;
        if (this.port instanceof XpViewport) {
            XpAnnotationPolicy ap = XpAnnotationModel.getAnnotationPolicy();
            afont = ap.getAnnotationFont(((XpViewport)((Object)this.port)).getWidth(), ((XpViewport)((Object)this.port)).getHeight());
        }
        Font f = afont != null ? afont.deriveFont(1, 16.0f) : this.topLabel.getFont().deriveFont(1, 16.0f);
        this.topLabel.setFont(f);
        this.bottomLabel.setFont(f);
        this.topLabel.setText(top);
        this.bottomLabel.setText(bottom);
        this.updateUI();
    }

    public void updateSlider() {
        if (this.port == null) {
            return;
        }
        int n = this.port.getNumFrames();
        BoundedRangeModel model = this.frameCtl.getModel();
        int newSliderValue = n - this.port.getFrameIndex();
        this.frameCtl.getModel().setRangeProperties(newSliderValue, 0, 1, n, model.getValueIsAdjusting());
    }

    public void updatePort() {
        int id = this.port.getNumFrames() - this.frameCtl.getValue();
        if (id != this.port.getFrameIndex()) {
            this.port.setFrameIndex(id);
        }
    }

    @Override
    public boolean isSupported(Capable capable) {
        return capable instanceof FramePositioningCapable && capable instanceof CvSeriesDisplayer;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateSlider();
        this.adjustScrollBar.stop();
        this.frameCtl.updateUI();
    }
}

