/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.apps.cdviewer.datasetloader;

import com.ge.med.cse.cvf.dataloader.DatasetValidator;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import java.util.Arrays;
import java.util.List;

public class MVMolalityDatasetValidator
implements DatasetValidator {
    @Override
    public String validateImages(DMTagValueInterface[] imgs) {
        if (imgs == null || imgs.length == 0) {
            return "NOT_SUPPORTED_MODALITY";
        }
        String supportedModality = CvPropertiesManager.getProperty("cvf.modalities");
        String[] allModality = supportedModality.split(",");
        List<String> supportedModalityList = Arrays.asList(allModality);
        if (imgs[0].getType().equalsIgnoreCase("image")) {
            String modality = imgs[0].getValue(new DMTag(8, 96)).toString().toLowerCase();
            if (supportedModalityList.contains(modality)) {
                return "SUPPORTED_MODALITY";
            }
            return "NOT_SUPPORTED_MODALITY";
        }
        if (imgs[0].getType().equalsIgnoreCase("series")) {
            for (int i = 0; i < imgs.length; ++i) {
                String modality = imgs[i].getValue(new DMTag(8, 96)).toString().toLowerCase();
                if (supportedModalityList.contains(modality)) continue;
                return "NOT_SUPPORTED_MODALITY";
            }
            return "SUPPORTED_MODALITY";
        }
        return "NOT_SUPPORTED_MODALITY";
    }
}

