/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.apps.cdviewer;

import com.ge.med.cse.cvf.util.CvImageFusionUtils;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

public class MVUtils {
    public static final String FILESEPARATOR = System.getProperty("file.separator");

    public static String checkModalityForVolumeBuild(DMObject serObj) {
        String type;
        String selectedModality;
        String supportedVol = CvPropertiesManager.getProperty("cvf.j3d.modalities", "ct,pt,mr");
        String[] allModality = supportedVol.split(",");
        List<String> modalitylist = Arrays.asList(allModality);
        if (!modalitylist.contains((selectedModality = DicomUtils.getModality(serObj)).toLowerCase())) {
            return "INVALID_MODALITY";
        }
        if (selectedModality.equalsIgnoreCase("ct") && null != (type = DicomUtils.getCTImageType(serObj, true)) && type.equalsIgnoreCase("SCOUT")) {
            return "INVALID_FOR_VLUME";
        }
        return "VALID_MODALITY";
    }

    public static boolean get2D3DToggleStatus(DMObject[] serObj) {
        boolean enable = false;
        if (serObj != null) {
            for (DMObject ser : serObj) {
                if (ser == null || !MVUtils.checkModalityForVolumeBuild(ser).equalsIgnoreCase("VALID_MODALITY")) {
                    enable = false;
                    break;
                }
                enable = true;
            }
        }
        return enable;
    }

    public static DMObject[][] sortPRseries(DMObject seriesObject) {
        DMObject[] images = seriesObject.getRelated("image");
        return MVUtils.sortImages(images);
    }

    public static DMObject[][] sortImages(DMObject[] images) {
        DMObject[][] result = new DMObject[images.length][];
        CvUtils.sortImages(images);
        for (int i = 0; i < images.length; ++i) {
            result[i] = new DMObject[]{images[i]};
        }
        return result;
    }

    public static boolean isPRSeries(DMObject dmo) {
        return dmo != null && "PR".equalsIgnoreCase((String)dmo.getValue(new DMTag(8, 96)));
    }

    public static DMTag[] getNeededTags(DMTagValueInterface series) {
        String modatliy = series.getValue(new DMTag(8, 96)).toString();
        return CvUtils.getNeededTags("" + modatliy, "");
    }

    public static boolean isSR(DMObject dmo) {
        return dmo != null && "SR".equalsIgnoreCase((String)dmo.getValue(new DMTag(8, 96)));
    }

    public static boolean isScoutImage(DMObject seriesDMObject) {
        String imageType = (String)seriesDMObject.getValue(CvImageFusionUtils.IMAGE_TYPE_DMTAG);
        return imageType != null && imageType.indexOf("ORIGINAL") >= 0 && imageType.indexOf("PRIMARY") >= 0 && imageType.indexOf("LOCALIZER") >= 0;
    }

    public static String getModality(DMTagValueInterface dmObject) {
        String modality = DicomUtils.getModality(dmObject);
        return MVUtils.getModality(modality);
    }

    public static String getModality(String modality) {
        if (modality == null) {
            return " ";
        }
        String modality_ = modality.trim();
        if (modality_.equalsIgnoreCase("CT")) {
            return "CT";
        }
        if (modality_.equalsIgnoreCase("MR")) {
            return "MR";
        }
        if (modality_.equalsIgnoreCase("GEMS PET RAW")) {
            return "Raw";
        }
        if (modality_.equalsIgnoreCase("PT")) {
            return "PT";
        }
        if (modality_.equalsIgnoreCase("PR")) {
            return "PR";
        }
        if (modality_.equalsIgnoreCase("SR")) {
            return "SR";
        }
        return modality_;
    }

    public static boolean isCompareModePageSynchSupported(DMObject objRef1, DMObject objRef2) {
        String[] str = CvPropertiesManager.getProperty("mv.compareMode.pagingUnsync.supported.modalilities").split(",");
        List<String> unSupportedModalitiesForPagingUnsyncInCompareMode = Arrays.asList(str);
        return !unSupportedModalitiesForPagingUnsyncInCompareMode.contains(MVUtils.getModality(objRef1)) && !unSupportedModalitiesForPagingUnsyncInCompareMode.contains(MVUtils.getModality(objRef2));
    }

    public static void verifyLocale() {
        HashSet<Locale> supported = new HashSet<Locale>();
        Locale defaultLocale = Locale.getDefault();
        String localesString = CvPropertiesManager.getProperty("cvf.locales");
        String[] locales = localesString.split(",");
        if (locales != null) {
            for (String str : locales) {
                String[] locale = str.split("_");
                if (locale == null || locale.length != 2) continue;
                supported.add(new Locale(locale[0], locale[1]));
            }
        }
        if (!supported.contains(defaultLocale)) {
            System.err.println("Local " + defaultLocale + ", " + defaultLocale.getCountry() + " not supported using English");
            Locale.setDefault(new Locale("en", "US"));
        }
        System.err.println("Before verifying locale:" + defaultLocale + "\nAfter verifying :" + Locale.getDefault());
    }
}

