/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.apps.cdviewer;

import com.ge.med.cse.cvf.base.CvImageLoader;
import com.ge.med.cse.cvf.base.CvSeriesDisplayer;
import com.ge.med.cse.cvf.base.OnportAlphaSliderVc;
import com.ge.med.cse.cvf.idc.AlphaBlender;
import com.ge.med.cse.cvf.util.CvFusionPixelCombiner;
import com.ge.med.cse.cvf.util.CvImageFusionUtils;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.idc.XjFusionPixelCombiner;
import com.ge.med.idc.XjImage;
import com.ge.med.terra.jami.XpMedicalImage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MVFusionSeriesDisplayer
extends CvSeriesDisplayer {
    int fusionlayer = 1;

    public MVFusionSeriesDisplayer() {
        this.setSharedRenderAttributes(true);
        String pixelCombinerstr = CvPropertiesManager.getProperty("PixelCombiner", CvFusionPixelCombiner.class.getName());
        XjFusionPixelCombiner pixelCombiner = null;
        try {
            pixelCombiner = (XjFusionPixelCombiner)Thread.currentThread().getContextClassLoader().loadClass(pixelCombinerstr).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setPixelCombiner(pixelCombiner);
        OnportAlphaSliderVc vc = new OnportAlphaSliderVc((AlphaBlender)((Object)pixelCombiner)){

            @Override
            protected void setSliderPosition() {
                this.slider.setName("MVAlphaSlider");
                this.slider.setOrientation(0);
                final JLabel sliderPosIndicator = new JLabel();
                sliderPosIndicator.setName("MVAlphaLabel");
                sliderPosIndicator.setForeground(Color.CYAN);
                JPanel tempPanel = new JPanel(new BorderLayout());
                tempPanel.setOpaque(false);
                tempPanel.add((Component)sliderPosIndicator, "South");
                JPanel indicatorPanel = new JPanel(new BorderLayout());
                indicatorPanel.add((Component)tempPanel, "East");
                indicatorPanel.add(this.slider);
                indicatorPanel.setOpaque(false);
                JPanel pan = new JPanel();
                pan.setOpaque(false);
                pan.setLayout(new GridLayout(2, 1));
                pan.add(new JLabel(""));
                pan.add(indicatorPanel);
                this.add((Component)pan, "North");
                pan.repaint();
                sliderPosIndicator.setText("  " + this.slider.getValue() + " %");
                this.slider.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        sliderPosIndicator.setText("  " + slider.getValue() + " %");
                    }
                });
            }
        };
        this.getPort(0).getMedicalImageVc().getImageVc().add(vc);
    }

    @Override
    public int addImageLayer(XjImage[] imgs) {
        this.fusionlayer = super.addImageLayer(imgs);
        this.applyHotCmap();
        return this.fusionlayer;
    }

    @Override
    public void setImages(XpMedicalImage[] images) {
        if (images == null || images[0] == null || images[0].getSlice() == null) {
            int layers = this.getNumImageLayers();
            for (int i = 0; i < layers; ++i) {
                this.removeImageLayer(i);
            }
        }
        super.setImages(images);
    }

    @Override
    public void resetWindowing() {
        super.resetWindowing();
        this.applyHotCmap();
        this.getPort(0).resetWindowing();
    }

    @Override
    public void replaceImage(XpMedicalImage image, int index) {
        super.replaceImage(image, index);
        if (index == 0) {
            this.resetWindowing();
        }
        this.applyHotCmap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyHotCmap() {
        int[] cMap = null;
        InputStream inStream = null;
        try {
            inStream = CvImageLoader.class.getResourceAsStream("/com/ge/med/cse/cvf/util/hot.cm");
            if (inStream != null) {
                cMap = CvImageFusionUtils.loadRGBColorTable(inStream);
                this.setColorMap(cMap);
                inStream.close();
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        this.setVideoInverted(false);
    }

    public int getFusionlayer() {
        return this.fusionlayer;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.removeImageLayer(this.getFusionlayer());
    }
}

