/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.apps.cdviewer;

import com.ge.med.cse.apps.cdviewer.License;
import com.ge.med.cse.apps.cdviewer.MVApplicationContext;
import com.ge.med.cse.apps.cdviewer.MVDMSystem;
import com.ge.med.cse.apps.cdviewer.MVDataContext;
import com.ge.med.cse.apps.cdviewer.MVFusionJ3DPort;
import com.ge.med.cse.apps.cdviewer.MVUtils;
import com.ge.med.cse.apps.cdviewer.MediaRemovalDetector;
import com.ge.med.cse.apps.cdviewer.MvWinLinkDirector;
import com.ge.med.cse.apps.cdviewer.RedirectedStream;
import com.ge.med.cse.apps.cdviewer.ThreadExceptionHandler;
import com.ge.med.cse.apps.cdviewer.datasetloader.MVCachedVolumeLoader;
import com.ge.med.cse.apps.cdviewer.datasetloader.MVImageLoader;
import com.ge.med.cse.apps.cdviewer.lnf.LookAndFeelUtil;
import com.ge.med.cse.apps.cdviewer.ui.ControlPanel;
import com.ge.med.cse.cvf.appframework.Application;
import com.ge.med.cse.cvf.appframework.ApplicationContext;
import com.ge.med.cse.cvf.appframework.ContextProvider;
import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.base.BaseScreen;
import com.ge.med.cse.cvf.base.CvImageLoader;
import com.ge.med.cse.cvf.base.CvSeriesDisplayer;
import com.ge.med.cse.cvf.base.LinkedCursorDirector;
import com.ge.med.cse.cvf.base.XpFrameLinkDirector;
import com.ge.med.cse.cvf.base.XpZoomLinkDirector;
import com.ge.med.cse.cvf.dataloader.Dataset;
import com.ge.med.cse.cvf.dataloader.DatasetLoaderUtils;
import com.ge.med.cse.cvf.dataloader.DefaultVolumeDataSetValidator;
import com.ge.med.cse.cvf.dataloader.adv.XpImageDataSetValidator;
import com.ge.med.cse.cvf.dataloader.adv.XpReplaceImageLoader;
import com.ge.med.cse.cvf.dataloader.basic.DynamicVolumeDatasetLayeredLoader;
import com.ge.med.cse.cvf.dataloader.basic.DynamicVolumeDatasetLoader;
import com.ge.med.cse.cvf.dataloader.basic.DynamicVolumeDatasetModel;
import com.ge.med.cse.cvf.dataloader.basic.ImageDatasetModel;
import com.ge.med.cse.cvf.idc.MultiSelectionCapable;
import com.ge.med.cse.cvf.idc.ViewTypeCapable;
import com.ge.med.cse.cvf.idc.XpLinkPortCapable;
import com.ge.med.cse.cvf.j3d.J3DLinkedCursorDirector;
import com.ge.med.cse.cvf.j3d.J3DPANLinkedDirector;
import com.ge.med.cse.cvf.j3d.J3DViewport;
import com.ge.med.cse.cvf.j3d.J3DWindowingLinkedDirector;
import com.ge.med.cse.cvf.j3d.J3DZoomLinkedDirector;
import com.ge.med.cse.cvf.j3d.cpanels.J3DThkPagingPopPanel;
import com.ge.med.cse.cvf.j3d.ui.J3DThickScrollBar;
import com.ge.med.cse.cvf.j3d.utils.J3DGeomUtils;
import com.ge.med.cse.cvf.screenbuilder.ScreenLoader;
import com.ge.med.cse.cvf.screenbuilder.helper.ActiveAnnotationHelper;
import com.ge.med.cse.cvf.sr.SR2HTMLReportGenerator;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.RowColCapable;
import com.ge.med.idc.TaskMonitor;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.XpViewportDirector;
import com.ge.med.terra.jami.j3d.CubeTrackball;
import com.ge.med.terra.jami.j3d.T3DComponent;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.xpv.base.PlasmaControl;
import com.ge.med.terra.xpv.base.XPscreenLayout;
import com.ge.med.terra.xpv.onport.XPopPanel;
import com.ge.med.terra.xpv.ui.FadeAwayOverLay;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CDViewerAppMain
extends Application {
    public static final String JAR_LOADED_MESSAGE = "Loading annotations from the pluging jar and using \"com.ge.med.StdAnno.DXApStyle\" ";
    public static final String JAR_NOT_LOADED_MESSAGE = "Failed loading annotations from the pluging, hence using the default \"com.ge.med.cse.apps.cdviewer.DXDisplayApStyle\"";
    public static final String DATA_LOADING_BEGIN = "data_loading_begin";
    public static final String DATA_LOADING_COMPLETE = "data_loading_complete";
    public static final String PROGRESSIVE_DATA_LOADING_BEGIN = "progressive_data_loading_begin";
    public static final String PROGRESSIVE_DATA_LOADING_STATUS = "progressive_data_loading_status";
    public static final String ENABLE_3D_MODE = "enable_3d_mode";
    private static BaseScreen screen = null;
    private MVApplicationContext app_ = null;
    private boolean is3DMode = true;
    private boolean is3DModeEnabled = true;
    private DMObject[] objRef = null;
    private ResourceBundle bundle = null;
    private ControlPanel controlPane = new ControlPanel();
    private static MVImageLoader imageLoader = new MVImageLoader();
    private ActiveAnnotationHelper helper = new ActiveAnnotationHelper();
    private static DMObject[] lastDmo3D = null;
    private static DMObject[] lastDmo2D = null;
    private static J3DLinkedCursorDirector linkedDirector = new J3DLinkedCursorDirector();
    private XpZoomLinkDirector zoomDirector = new XpZoomLinkDirector();
    private MvWinLinkDirector winDirector = new MvWinLinkDirector();
    private XpFrameLinkDirector frameLinkDirector = new XpFrameLinkDirector();
    private DynamicVolumeDatasetLayeredLoader layeredLoader = new DynamicVolumeDatasetLayeredLoader();
    private DynamicVolumeDatasetModel layeredModel = new DynamicVolumeDatasetModel();
    private static ScreenViewTypeHelper viewtypeHelper = null;
    private LinkedCursorDirector linkedcursorDirector2d = new LinkedCursorDirector();
    private DynamicVolumeDatasetModel dvoldatasetmodel = new DynamicVolumeDatasetModel();
    private MVCachedVolumeLoader cahcedLoader = new MVCachedVolumeLoader();
    private static ExecutorService service;
    private JPanel mainPanel = new JPanel();
    J3DPANLinkedDirector panDirector = new J3DPANLinkedDirector();
    J3DWindowingLinkedDirector winLinkDirector = new J3DWindowingLinkedDirector();
    J3DZoomLinkedDirector zoomLinkDirector = new J3DZoomLinkedDirector();

    private void sync3DportDFOV() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                J3DViewport port;
                int i;
                JComponent[] allPort = screen.getPorts();
                int size = allPort.length;
                HashMap<String, Double> maxdfovmap = new HashMap<String, Double>();
                maxdfovmap.put("AXIAL", 0.0);
                maxdfovmap.put("CORONAL", 0.0);
                maxdfovmap.put("SAGITTAL", 0.0);
                maxdfovmap.put("OBLIQUE", 0.0);
                CDViewerAppMain.this.zoomLinkDirector.disconnectAllViewports();
                for (i = 0; i < size; ++i) {
                    if (!(allPort[i] instanceof J3DViewport)) continue;
                    port = (J3DViewport)allPort[i];
                    if (maxdfovmap.get(port.getViewType()) == null) {
                        maxdfovmap.put(port.getViewType(), port.getViewHeight());
                        continue;
                    }
                    if (!((Double)maxdfovmap.get(port.getViewType()) < port.getViewHeight())) continue;
                    maxdfovmap.put(port.getViewType(), port.getViewHeight());
                }
                for (i = 0; i < size; ++i) {
                    if (!(allPort[i] instanceof J3DViewport) || !((port = (J3DViewport)allPort[i]).getViewHeight() < (Double)maxdfovmap.get(port.getViewType()))) continue;
                    port.setViewHeight((Double)maxdfovmap.get(port.getViewType()));
                }
                maxdfovmap.clear();
                CDViewerAppMain.this.connectDirector(CDViewerAppMain.this.zoomLinkDirector, allPort);
            }
        };
        CDViewerAppMain.swingSafe(r, false);
    }

    public CDViewerAppMain() {
        this.init();
        this.jbInit();
        System.out.println(CvUtils.getDMSystem().getSystemName());
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)this.controlPane.getToolBar(), "North");
        JPanel notForClinicals_Screen = new JPanel(new BorderLayout());
        JLabel notForClinicals = new JLabel("", 0);
        notForClinicals.setOpaque(false);
        notForClinicals.setText(this.bundle.getString("NOT_FOR_CLINICAL_USE"));
        notForClinicals.setName("NotForClinicalUseSafetyString");
        notForClinicals.setForeground(Color.RED);
        notForClinicals.setBackground(UIManager.getColor("P8"));
        notForClinicals.setLayout(new BorderLayout());
        notForClinicals_Screen.add(screen);
        notForClinicals_Screen.add((Component)this.controlPane.getDataSelector(), "West");
        this.mainPanel.add(notForClinicals_Screen);
        this.configureKeyBoardAction();
        this.controlPane.addPropertyChangeListener("LayoutChange", new ScreenChangeListern());
        TaskMonitor delegatorTaskmonitor = new TaskMonitor(){
            private int totalUnits = 0;

            @Override
            public void taskBegin(String taskName, int totalWork) {
                this.totalUnits = totalWork;
                CDViewerAppMain.this.controlPane.getTaskMonitor().taskBegin(taskName, totalWork);
                ScreenLoader screenloader = CDViewerAppMain.this.app_.getScreenloader();
                if (taskName.equals("DATA_LOADING_TASK_2D_FUSION_IMAGE")) {
                    CDViewerAppMain.this.zoomDirector.disconnectAllViewports();
                    CDViewerAppMain.this.winDirector.disconnectAllViewports();
                    CDViewerAppMain.this.frameLinkDirector.disconnectAllViewports();
                } else if (taskName.equals("DATA_LOADING_TASK_2D_SINGLE_IMAGE")) {
                    String modality = DicomUtils.getModality(CDViewerAppMain.this.objRef[0]);
                    CDViewerAppMain.this.zoomDirector.disconnectAllViewports();
                    CDViewerAppMain.this.winDirector.disconnectAllViewports();
                    CDViewerAppMain.this.frameLinkDirector.disconnectAllViewports();
                    JComponent[] ports = screenloader.getVScreen().getPorts();
                    int[] rowColValue = CDViewerAppMain.this.getDefaultRowCol(modality);
                    for (int i = 0; i < ports.length; ++i) {
                        CDViewerAppMain.this.setRowCol(ports[i], rowColValue[0], rowColValue[1]);
                    }
                } else if (taskName.equals("DATA_LOADING_TASK_2D_CIOMPARE_IMAGE")) {
                    CDViewerAppMain.this.zoomDirector.disconnectAllViewports();
                    CDViewerAppMain.this.winDirector.disconnectAllViewports();
                    CDViewerAppMain.this.frameLinkDirector.disconnectAllViewports();
                    if (MVUtils.isCompareModePageSynchSupported(CDViewerAppMain.this.objRef[0], CDViewerAppMain.this.objRef[1])) {
                        CDViewerAppMain.this.connectDirector(CDViewerAppMain.this.frameLinkDirector, screenloader.getVScreen().getPorts());
                    }
                    JComponent[] ports = screenloader.getVScreen().getPorts();
                    for (int i = 0; i < ports.length; ++i) {
                        CDViewerAppMain.this.setRowCol(ports[i], 1, 1);
                    }
                    ((CvSeriesDisplayer)ports[1]).setDisplayMode(((CvSeriesDisplayer)ports[0]).getDisplayMode());
                }
                CDViewerAppMain.this.add3DDirector(CDViewerAppMain.this.is3DMode);
                CDViewerAppMain.this.firePropertyChange(CDViewerAppMain.DATA_LOADING_BEGIN, null, taskName);
            }

            @Override
            public void taskDone(final String taskName) {
                CDViewerAppMain.this.mainPanel.setCursor(Cursor.getDefaultCursor());
                CDViewerAppMain.this.controlPane.getTaskMonitor().taskDone(taskName);
                if (taskName.equalsIgnoreCase("DATA_LOADING_TASK_2D_SINGLE_IMAGE") || taskName.equalsIgnoreCase("DATA_LOADING_TASK_2D_CIOMPARE_IMAGE") || taskName.equalsIgnoreCase("DATA_LOADING_TASK_2D_FUSION_IMAGE")) {
                    CDViewerAppMain.access$2202(CDViewerAppMain.this.objRef);
                } else {
                    CDViewerAppMain.access$2302(CDViewerAppMain.this.objRef);
                }
                if (taskName.equals("DATA_LOADING_TASK_VOLUME_FUSION")) {
                    String[] str = CvPropertiesManager.getProperty("screens.3d").split(",");
                    ScreenLoader scrnLoader = CDViewerAppMain.this.app_.getScreenloader();
                    for (int i = 0; i < str.length; ++i) {
                        if (!scrnLoader.isDisplayNamePresent(str[i]) || !(scrnLoader.getScreen(str[i]).getPorts() instanceof J3DViewport[])) continue;
                        CDViewerAppMain.this.cahcedLoader.loadVolumes(str[i], (J3DViewport[])scrnLoader.getScreen(str[i]).getPorts());
                    }
                }
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        CDViewerAppMain.this.firePropertyChange(CDViewerAppMain.DATA_LOADING_COMPLETE, null, taskName);
                        if (CDViewerAppMain.this.objRef.length == 2) {
                            viewtypeHelper.configScren("DefaultFused", true, false);
                        } else {
                            viewtypeHelper.configScren("SingleVolume", true, false);
                        }
                    }
                };
                CDViewerAppMain.swingSafe(runnable, true);
            }

            @Override
            public void taskProgress(String taskName, int units) {
                ScreenLoader screenloader = CDViewerAppMain.this.app_.getScreenloader();
                if (units == 0) {
                    final JComponent[] ports = screenloader.getVScreen().getPorts();
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            CDViewerAppMain.this.disableFusionSlider();
                            CDViewerAppMain.this.firePropertyChange(CDViewerAppMain.PROGRESSIVE_DATA_LOADING_BEGIN, 0, totalUnits);
                        }
                    };
                    CDViewerAppMain.swingSafe(r, false);
                    if (taskName.equals("DATA_LOADING_TASK_2D_FUSION_IMAGE")) {
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                CDViewerAppMain.this.connectDirector(CDViewerAppMain.this.zoomDirector, ports);
                                CDViewerAppMain.this.connectDirector(CDViewerAppMain.this.winDirector, ports);
                                CDViewerAppMain.this.connectDirector(CDViewerAppMain.this.frameLinkDirector, ports);
                                CDViewerAppMain.this.connectDirector(CDViewerAppMain.this.linkedcursorDirector2d, ports);
                            }
                        };
                        CDViewerAppMain.swingSafe(runnable, true);
                    }
                } else if (units == 1) {
                    CDViewerAppMain.this.sync3DportDFOV();
                    CDViewerAppMain.this.mainPanel.setCursor(Cursor.getDefaultCursor());
                    if (taskName.equals("DATA_LOADING_TASK_VOLUME_FUSION") || taskName.equalsIgnoreCase("DATA_LOADING_TASK_VOLUME_SINGLE")) {
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                for (int i = 0; i < screen.getNumPorts() && screen.getPort(i) instanceof J3DViewport; ++i) {
                                    linkedDirector.connectViewport((XpViewport)screen.getPort(i));
                                    try {
                                        CDViewerAppMain.this.helper.config((XpViewport)screen.getPort(i), "j3dvp" + i, CvPropertiesManager.getProperties());
                                        continue;
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                        };
                        CDViewerAppMain.swingSafe(runnable, true);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (CDViewerAppMain.this.isAppMode3D()) {
                                    screen.selectAll();
                                } else {
                                    screen.setComponentSelection(-1);
                                    screen.setComponentSelection(0);
                                }
                                screen.updateSelection();
                            }
                        });
                    }
                }
                if (units > 0) {
                    CDViewerAppMain.this.firePropertyChange(CDViewerAppMain.PROGRESSIVE_DATA_LOADING_STATUS, 0, units);
                }
                CDViewerAppMain.this.controlPane.getTaskMonitor().taskProgress(taskName, units);
            }

            @Override
            public void taskFailed(String taskName, String reason, Exception e) {
                CDViewerAppMain.this.mainPanel.setCursor(Cursor.getDefaultCursor());
                final ScreenLoader screenloader = CDViewerAppMain.this.app_.getScreenloader();
                if (reason.equals("INVALID_FUSION_IMAGE")) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                screenloader.showScreen("Image2DCompare");
                                imageLoader.loadImages(CDViewerAppMain.this.objRef, "MODE_2D_COMPARE");
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                        }
                    });
                    return;
                }
                if (reason.equals("DATA_LOADING_EXCEPTION")) {
                    JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(screen), CvUtils.getResourceBundle().getString("ERROR_FAILED_TO_LOAD"));
                    return;
                }
                if (reason.equals("EXCEEEDS_SIZE")) {
                    JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(screen), CvUtils.getResourceBundle().getString("EXCEEDS_IMAGES_SIZE"));
                } else if (!(reason.equals("INVALID_IMAGETYPE") || reason.equals("INVALID_FOR_VOLUME") || reason.equals("INVALID_MODALITY"))) {
                    if (reason.equalsIgnoreCase(J3DGeomUtils.getErrorString(4).trim())) {
                        JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(screen), CvUtils.getResourceBundle().getString("SLICE_SPACING_NOT_MATCHING"));
                    } else {
                        JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(screen), CvUtils.getResourceBundle().getString("VOLUME_CAN_NOT_BUILT"));
                    }
                }
                CDViewerAppMain.this.enable3DMode(false);
                CDViewerAppMain.this.switchAppMode("MODE2D");
                CDViewerAppMain.this.controlPane.getTaskMonitor().taskFailed(taskName, reason, e);
            }
        };
        imageLoader.setTaskMoitor(delegatorTaskmonitor);
    }

    private void configureKeyBoardAction() {
        int kbActionCount = Integer.parseInt(CvPropertiesManager.getProperty("KeyBoardAction", "0"));
        for (int i = 0; i < kbActionCount; ++i) {
            int inputPolicy;
            String[] keyBoardActions = CvPropertiesManager.getProperty("KeyBoardAction." + i).split(",");
            String strCompToAdd = keyBoardActions[0];
            Action action = (Action)CvUtils.createInstance(keyBoardActions[1]);
            String strActionName = action.getValue("Name") != null ? action.getValue("Name").toString() : action.getClass().getName();
            KeyStroke ks = KeyStroke.getKeyStroke(keyBoardActions[2]);
            int n = inputPolicy = strCompToAdd.length() > 4 ? Integer.parseInt(keyBoardActions[3]) : 2;
            if (strCompToAdd.equalsIgnoreCase("XPScreen")) {
                screen.getInputMap(inputPolicy).put(ks, strActionName);
                screen.getActionMap().put(strActionName, action);
            }
            if (!(action instanceof PlasmaControl)) continue;
            ((PlasmaControl)((Object)action)).setCapable(screen);
        }
    }

    private void disableFusionSlider() {
        int numport = screen.getNumPorts();
        for (int i = 0; i < numport; ++i) {
            Component[] com;
            JComponent port = screen.getPort(i);
            FadeAwayOverLay fadeAwayOverLay = (FadeAwayOverLay)port.getClientProperty("FadeAwayOverLay");
            if (fadeAwayOverLay == null) continue;
            if (port instanceof MVFusionJ3DPort) {
                Component[] com2;
                int layer = ((MVFusionJ3DPort)port).getNumVolumeLayers();
                boolean toEnable = true;
                if (layer > 1) {
                    toEnable = false;
                }
                for (Component co : com2 = fadeAwayOverLay.getOnPortComponents()) {
                    if (!(co instanceof J3DThkPagingPopPanel)) continue;
                    J3DThkPagingPopPanel pan = (J3DThkPagingPopPanel)co;
                    pan.setThicknessControlEnabled(toEnable);
                }
            }
            if (!(port instanceof XpViewport)) continue;
            for (Component co : com = fadeAwayOverLay.getOnPortComponents()) {
                Component[] allComp;
                if (!(co instanceof XPopPanel)) continue;
                XPopPanel popPanel = (XPopPanel)co;
                XPopPanel.setProperties(CvPropertiesManager.getProperties());
                ((XPopPanel)co).fire();
                XPopPanel.setProperties(CvPropertiesManager.getProperties());
                ((XPopPanel)co).fire();
                for (Component comp : allComp = popPanel.getComponents()) {
                    if (!(comp instanceof J3DThickScrollBar)) continue;
                    J3DThickScrollBar scrollBar = (J3DThickScrollBar)comp;
                    scrollBar.setBackground(null);
                    scrollBar.setOpaque(false);
                }
            }
        }
    }

    protected void init() {
        this.bundle = CvUtils.getResourceBundle();
        screen = new BaseScreen();
        screen.setName("MV_BASE_SCREEN");
        screen.setProperties(CvPropertiesManager.getProperties());
        screen.setLayout(XPscreenLayout.layout1x1());
        screen.addPort(new CvSeriesDisplayer(), 0);
        this.initAppFrameWork();
        this.controlPane.setCapable(screen);
        this.controlPane.setProperties(CvPropertiesManager.getProperties());
        viewtypeHelper = new ScreenViewTypeHelper();
        CvImageLoader.getInstance().setScreen(screen);
    }

    private void initAppFrameWork() {
        this.app_ = new MVApplicationContext();
        ContextProvider.registerApplicationContext("MediaViewer", this.app_);
        MVDataContext dataContext = new MVDataContext();
        ContextProvider.registerDataContext("MediaViewer", dataContext);
        ScreenLoader screenloader = null;
        try {
            screenloader = new ScreenLoader(screen, CvPropertiesManager.getProperties());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.app_.setApplication(this);
        this.app_.setScreenloader(screenloader);
        this.app_.setTaskMonitor(this.controlPane.getTaskMonitor());
        DynamicVolumeDatasetLoader dvoldatasetloader = new DynamicVolumeDatasetLoader();
        this.dvoldatasetmodel.setDataset(new Dataset("DATASET_3D_SINGLE"));
        this.dvoldatasetmodel.getDataset().setDataSetValidator(new DefaultVolumeDataSetValidator());
        this.layeredModel.setDataset(new Dataset("DATASET_3D_FUSION"));
        this.layeredModel.getDataset().setDataSetValidator(new DefaultVolumeDataSetValidator());
        dataContext.putDatasetLoader("DATASET_3D_SINGLE", dvoldatasetloader);
        dataContext.putDatasetModel("DATASET_3D_SINGLE", this.dvoldatasetmodel);
        dataContext.putDatasetLoader("DATASET_3D_FUSION", this.layeredLoader);
        dataContext.putDatasetModel("DATASET_3D_FUSION", this.layeredModel);
        XpReplaceImageLoader replaceImgLoader = new XpReplaceImageLoader();
        ImageDatasetModel imgDatasetmodel = new ImageDatasetModel(new Dataset("DATASET_2D_1"));
        imgDatasetmodel.getDataset().setDataSetValidator(new XpImageDataSetValidator());
        dataContext.putDatasetLoader("DATASET_2D_1", replaceImgLoader);
        dataContext.putDatasetModel("DATASET_2D_1", imgDatasetmodel);
        ImageDatasetModel imgDatasetmodel2 = new ImageDatasetModel(new Dataset("DATASET_2D_2"));
        imgDatasetmodel2.getDataset().setDataSetValidator(new XpImageDataSetValidator());
        dataContext.putDatasetLoader("DATASET_2D_2", replaceImgLoader);
        dataContext.putDatasetModel("DATASET_2D_2", imgDatasetmodel2);
        imageLoader.setScreen(screen);
        if (screenloader != null) {
            screenloader.addPropertyChangeListener("ScreenDisplayed", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    CDViewerAppMain.this.firePropertyChange("ScreenDisplayed", evt.getOldValue(), evt.getNewValue());
                }
            });
        } else {
            System.err.println("CDViewerAppMain.initAppFrameWork screenloader is null.");
        }
    }

    private void jbInit() {
        this.controlPane.getDataSelector().addSelectionChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CDViewerAppMain.access$1702(CDViewerAppMain.this, (DMObject[])e.getSource());
                if (CDViewerAppMain.this.objRef == null || CDViewerAppMain.this.objRef.length == 0) {
                    return;
                }
                CDViewerAppMain.this.setDefaultLoadMode();
            }
        });
        XpLinkPortCapable lnkCap = (XpLinkPortCapable)screen.getCapable(XpLinkPortCapable.class.getName());
        if (lnkCap != null) {
            lnkCap.setPortsLinked(true);
        }
        screen.addPropertyChangeListener("Cine", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean isCine = Boolean.parseBoolean(evt.getNewValue().toString());
                if (!CDViewerAppMain.this.is3DMode && CDViewerAppMain.this.app_ != null && CDViewerAppMain.this.app_.getScreenloader() != null && CDViewerAppMain.this.app_.getScreenloader().getVScreen() != null && CDViewerAppMain.this.app_.getScreenloader().getVScreen().getDisplayName() != null && CDViewerAppMain.this.app_.getScreenloader().getVScreen().getDisplayName().equals("Image2DFusion")) {
                    if (isCine) {
                        CDViewerAppMain.this.linkedcursorDirector2d.disconnectAllViewports();
                    } else {
                        CDViewerAppMain.this.connectDirector(CDViewerAppMain.this.linkedcursorDirector2d, screen.getAllPorts());
                    }
                }
                for (int i = 0; i < screen.getNumPorts(); ++i) {
                    J3DViewport vp;
                    if (!(screen.getPort(i) instanceof J3DViewport) || !(vp = (J3DViewport)screen.getPort(i)).getViewType().equals("3D")) continue;
                    T3DComponent comp = vp.getT3DComponent();
                    Component[] allComp = comp.getComponents();
                    int size = allComp.length;
                    for (int j = 0; j < size; ++j) {
                        if (!(allComp[j] instanceof CubeTrackball)) continue;
                        CubeTrackball trackBall = (CubeTrackball)allComp[j];
                        trackBall.setVisible(!isCine);
                    }
                }
            }
        });
    }

    public boolean is3DModeEnabled() {
        return this.is3DModeEnabled;
    }

    public void enable3DMode(boolean enable) {
        boolean old = this.is3DModeEnabled;
        this.is3DModeEnabled = enable;
        this.firePropertyChange(ENABLE_3D_MODE, old, enable);
    }

    private void switchAppMode(String mode) {
        if ("MODE3D".equalsIgnoreCase(mode)) {
            this.is3DMode = true;
            this.firePropertyChange("MODE3D", false, true);
        } else {
            this.is3DMode = false;
            this.firePropertyChange("MODE2D", false, true);
        }
        if (this.objRef == null || this.objRef.length == 0) {
            return;
        }
        if (lastDmo2D != this.objRef || lastDmo3D != this.objRef) {
            this.resetAndLoad();
        } else {
            try {
                this.updateScreen();
                ScreenLoader screenloader = this.app_.getScreenloader();
                if (this.is3DMode) {
                    if (lastDmo3D.length == 1) {
                        screenloader.showScreen("SingleVolume");
                    } else if (lastDmo3D.length == 2) {
                        screenloader.showScreen("DefaultFused");
                    }
                    screen.selectAll();
                    screen.updateSelection();
                } else {
                    if (lastDmo2D.length == 1) {
                        screenloader.showScreen("Image2DSingle");
                    } else if (lastDmo2D.length == 2) {
                        String modObj0 = DicomUtils.getModality(this.objRef[0]);
                        String modObj1 = DicomUtils.getModality(this.objRef[1]);
                        DMObject dmoCT = null;
                        DMObject dmoPT = null;
                        if (modObj0.equalsIgnoreCase("CT") && modObj1.equalsIgnoreCase("PT")) {
                            dmoCT = this.objRef[0];
                            dmoPT = this.objRef[1];
                        } else if (modObj0.equalsIgnoreCase("PT") && modObj1.equalsIgnoreCase("CT")) {
                            dmoPT = this.objRef[0];
                            dmoCT = this.objRef[1];
                        }
                        if (null != dmoCT && null != dmoPT && DatasetLoaderUtils.isFusionValid(dmoCT, dmoPT)) {
                            screenloader.showScreen("Image2DFusion");
                        } else {
                            screenloader.showScreen("Image2DCompare");
                        }
                    }
                    screen.setComponentSelection(-1);
                    screen.setComponentSelection(0);
                    screen.updateSelection();
                }
                this.disableFusionSlider();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.mainPanel.setCursor(Cursor.getDefaultCursor());
    }

    public boolean isAppMode3D() {
        return this.is3DMode;
    }

    private void setDefaultLoadMode() {
        if (this.objRef == null || this.objRef.length == 0) {
            return;
        }
        this.mainPanel.setCursor(Cursor.getPredefinedCursor(3));
        this.enable3DMode(MVUtils.get2D3DToggleStatus(this.objRef));
        boolean launch3D = this.is3DModeEnabled();
        if (launch3D) {
            if (this.objRef.length == 2) {
                String modality_1 = DicomUtils.getModality(this.objRef[0]);
                String modality_2 = DicomUtils.getModality(this.objRef[1]);
                if ("ct".equalsIgnoreCase(modality_1) && "pt".equalsIgnoreCase(modality_2) || "pt".equalsIgnoreCase(modality_1) && "ct".equalsIgnoreCase(modality_2)) {
                    String ctDefMode = CvPropertiesManager.getProperty("mv.ct.default.load");
                    String ptDefMode = CvPropertiesManager.getProperty("mv.pt.default.load");
                    if ("2d".equalsIgnoreCase(ctDefMode) && "3d".equalsIgnoreCase(ptDefMode)) {
                        this.switchAppMode("MODE3D");
                        return;
                    }
                }
            }
            for (int i = 0; i < this.objRef.length; ++i) {
                String modality = DicomUtils.getModality(this.objRef[0]);
                String defmode = CvPropertiesManager.getProperty("mv." + modality.toLowerCase() + ".default.load");
                if ("3d".equalsIgnoreCase(defmode)) continue;
                launch3D = false;
                break;
            }
        }
        if (launch3D) {
            this.switchAppMode("MODE3D");
        } else {
            this.switchAppMode("MODE2D");
        }
    }

    public JFrame showViewer() {
        JFrame frame = new JFrame(this.bundle.getString("MEDIA_VIEWER_NOT_FOR_CLINICAL_USE_FRAME_TITLE"));
        frame.setJMenuBar(this.controlPane.getMenuBar());
        frame.getContentPane().add(this.mainPanel);
        frame.pack();
        frame.setDefaultCloseOperation(3);
        frame.setExtendedState(6);
        frame.getRootPane().getLayeredPane().add((Component)new License(), JLayeredPane.MODAL_LAYER);
        frame.getRootPane().getLayeredPane().add((Component)new MediaRemovalDetector(), JLayeredPane.POPUP_LAYER);
        frame.addPropertyChangeListener("licenseagreed", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CDViewerAppMain.this.controlPane.getDataSelector().checkAutoLoad();
            }
        });
        frame.getRootPane().getLayeredPane().add((Component)this.controlPane.getHelpPanel(), JLayeredPane.MODAL_LAYER);
        this.controlPane.getDataSelector().loadData();
        frame.setVisible(true);
        return frame;
    }

    public static void main(String[] args) {
        CDViewerAppMain main = new CDViewerAppMain();
        main.showViewer();
    }

    private boolean checkSR() {
        String modality = DicomUtils.getModality(this.objRef[0]);
        return modality != null && modality.trim().equalsIgnoreCase("SR");
    }

    private boolean displaySR() {
        try {
            String modality = DicomUtils.getModality(this.objRef[0]);
            if (modality != null && modality.trim().equalsIgnoreCase("SR")) {
                SR2HTMLReportGenerator reportGenerator = new SR2HTMLReportGenerator(this.objRef[0]);
                reportGenerator.generateReport();
                reportGenerator = null;
                return true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    private void add3DDirector(boolean is3d) {
        if (is3d) {
            for (int i = 0; i < screen.getNumPorts(); ++i) {
                this.panDirector.connectViewport((XpViewport)screen.getPort(i));
                this.winLinkDirector.connectViewport((XpViewport)screen.getPort(i));
                this.zoomLinkDirector.connectViewport((XpViewport)screen.getPort(i));
            }
        } else {
            this.panDirector.disconnectAllViewports();
            this.winLinkDirector.disconnectAllViewports();
            this.zoomLinkDirector.disconnectAllViewports();
        }
    }

    private void cleanAll3DPorts() {
        linkedDirector.disconnectAllViewports();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                CDViewerAppMain.this.dvoldatasetmodel.clearVolumeModels();
                CDViewerAppMain.this.layeredModel.clearVolumeModels();
                ScreenLoader screenloader = CDViewerAppMain.this.app_.getScreenloader();
                String[] allScreens3d = CvPropertiesManager.getProperty("screens.3d").split(",");
                int size = allScreens3d.length;
                for (int i = 0; i < size; ++i) {
                    JComponent[] allPorts;
                    if (!screenloader.isDisplayNamePresent(allScreens3d[i]) || screenloader.getVScreen().getDisplayName().equals(allScreens3d[i]) || (allPorts = screenloader.getScreen(allScreens3d[i]).getPorts()) == null) continue;
                    for (int j = 0; j < allPorts.length; ++j) {
                        if (!(allPorts[j] instanceof J3DViewport)) continue;
                        ((J3DViewport)allPorts[j]).setVolume(null);
                    }
                }
            }
        };
        service.submit(runnable);
    }

    private void updateScreen() {
        if (this.is3DMode) {
            screen.setPortSelectionMode(1);
        } else {
            screen.setPortSelectionMode(0);
            screen.setPrimaryBorder(MultiSelectionCapable.PRIMARY_SELECTION_BORDER);
            screen.setSecondaryBorder(MultiSelectionCapable.SECONDARY_SELECTION_BORDER);
        }
    }

    private void resetAndLoad() {
        this.updateScreen();
        XpImageDataSetValidator modalityValidator = new XpImageDataSetValidator();
        if (!modalityValidator.validateImages(this.objRef).equals("SUPPORTED_MODALITY")) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(screen, CvUtils.getResourceBundle().getString("SE_NOT_SUPPORTED"), CvUtils.getResourceBundle().getString("MEDIA_VIEWER_TITLE"), 0);
                }
            });
            return;
        }
        if (this.checkSR()) {
            if (!this.displaySR()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(screen, CvUtils.getResourceBundle().getString("ERROR_FAILED_TO_LOAD"), CvUtils.getResourceBundle().getString("MEDIA_VIEWER_TITLE"), 0);
                    }
                });
            }
            this.mainPanel.setCursor(Cursor.getDefaultCursor());
            return;
        }
        this.add3DDirector(false);
        ScreenLoader screenloader = this.app_.getScreenloader();
        if (this.isAppMode3D()) {
            try {
                boolean reload = this.objRef != lastDmo3D;
                linkedDirector.disconnectAllViewports();
                if (this.objRef.length == 2) {
                    screenloader.showScreen("DefaultFused");
                    viewtypeHelper.configScren("DefaultFused", false, false);
                } else {
                    screenloader.showScreen("SingleVolume");
                    viewtypeHelper.configScren("SingleVolume", false, false);
                }
                if (reload) {
                    this.cleanAll3DPorts();
                    JComponent[] comps = screenloader.getVScreen().getPorts();
                    for (int i = 0; i < comps.length; ++i) {
                        if (!(comps[i] instanceof J3DViewport)) continue;
                        J3DViewport vp = (J3DViewport)comps[i];
                        vp.setVolume(null);
                        if (!vp.getViewType().equals("3D")) continue;
                        vp.setViewType("OBLIQUE");
                    }
                    imageLoader.loadImages(this.objRef, "MODE3D");
                } else {
                    JComponent[] comps = screenloader.getVScreen().getPorts();
                    for (int i = 0; i < comps.length; ++i) {
                        if (!(comps[i] instanceof J3DViewport)) continue;
                        linkedDirector.connectViewport((J3DViewport)comps[i]);
                    }
                }
                this.disableFusionSlider();
                this.add3DDirector(this.is3DMode);
                screen.selectAll();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            try {
                String curMode = "MODE2D";
                if (this.objRef.length == 1) {
                    screenloader.showScreen("Image2DSingle");
                    if (this.objRef != lastDmo2D) {
                        this.linkedcursorDirector2d.disconnectAllViewports();
                        imageLoader.loadImages(this.objRef, curMode);
                    }
                } else if (this.objRef.length == 2) {
                    String modObj0 = DicomUtils.getModality(this.objRef[0]);
                    String modObj1 = DicomUtils.getModality(this.objRef[1]);
                    DMObject dmoCT = null;
                    DMObject dmoPT = null;
                    if (modObj0.equalsIgnoreCase("CT") && modObj1.equalsIgnoreCase("PT")) {
                        dmoCT = this.objRef[0];
                        dmoPT = this.objRef[1];
                    } else if (modObj0.equalsIgnoreCase("PT") && modObj1.equalsIgnoreCase("CT")) {
                        dmoPT = this.objRef[0];
                        dmoCT = this.objRef[1];
                    }
                    if (dmoCT != null && dmoPT != null && DatasetLoaderUtils.isFusionValid(dmoCT, dmoPT)) {
                        screenloader.showScreen("Image2DFusion");
                        JComponent[] allComp = screenloader.getVScreen().getPorts();
                        this.setRowCol(allComp[0], 1, 1);
                        this.setRowCol(allComp[1], 1, 1);
                        this.setRowCol(allComp[2], 1, 1);
                    } else {
                        screenloader.showScreen("Image2DCompare");
                        curMode = "MODE_2D_COMPARE";
                        this.linkedcursorDirector2d.disconnectAllViewports();
                    }
                    if (this.objRef != lastDmo2D) {
                        imageLoader.loadImages(this.objRef, curMode);
                    }
                }
                if (this.objRef != lastDmo2D && this.objRef != lastDmo3D) {
                    this.cleanAll3DPorts();
                }
                screen.setComponentSelection(-1);
                screen.setComponentSelection(0);
                screen.updateSelection();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void swingSafe(Runnable runnable, boolean isWait) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else if (isWait) {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void connectDirector(XpViewportDirector director, JComponent[] ports) {
        if (ports != null && ports[0] instanceof XpViewport) {
            for (int i = 0; i < ports.length; ++i) {
                director.connectViewport((XpViewport)ports[i]);
            }
        }
    }

    private int[] getDefaultRowCol(String modality) {
        String rowCol = null;
        int[] rowColValue = new int[2];
        if ("mg".equalsIgnoreCase(modality)) {
            rowCol = CvPropertiesManager.getProperty("mv.layout.rowcol.mg", "1,1");
            if (rowCol.isEmpty()) {
                rowCol = "1,1";
            }
        } else {
            rowCol = CvPropertiesManager.getProperty("mv.layout.rowcol.all", "2,2");
            if (rowCol.isEmpty()) {
                rowCol = "2,2";
            }
        }
        rowColValue[0] = Integer.parseInt(rowCol.split(",")[0]);
        rowColValue[1] = Integer.parseInt(rowCol.split(",")[1]);
        return rowColValue;
    }

    private void setRowCol(JComponent port, final int row, final int col) {
        if (port instanceof Capable) {
            Capable cap = (Capable)((Object)port);
            final RowColCapable rcCap = (RowColCapable)cap.getCapable(RowColCapable.class.getName());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    rcCap.setRowCol(row, col);
                }
            });
        }
    }

    @Override
    public void initialize(String[] args) {
    }

    @Override
    public void startup() {
    }

    @Override
    public void ready() {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public TaskMonitor getDataLoadingMonitor() {
        return this.controlPane.getTaskMonitor();
    }

    static /* synthetic */ DMObject[] access$2202(DMObject[] x0) {
        lastDmo2D = x0;
        return x0;
    }

    static /* synthetic */ DMObject[] access$2302(DMObject[] x0) {
        lastDmo3D = x0;
        return x0;
    }

    static /* synthetic */ DMObject[] access$1702(CDViewerAppMain x0, DMObject[] x1) {
        x0.objRef = x1;
        return x1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream inStream = null;
        try {
            String propToLoad;
            System.setProperty("APP_IDENTIFIER", "MediaViewer");
            System.setProperty("NO_LOCK", "true");
            System.setProperty("tap.dm.system.install", "false");
            System.setProperty("cuiPanel.resources", "com.ge.med.cse.apps.cdviewer.MvResource");
            CvPropertiesManager.setProperty("DMSystem", "MV#" + MVDMSystem.class.getName());
            if (System.getProperty("STOP_REDIRECT") == null) {
                RedirectedStream.initRedirect();
            }
            if ((inStream = CDViewerAppMain.class.getResourceAsStream(propToLoad = "MediaViewer.properties")) != null) {
                CvPropertiesManager.loadPropertyValues(inStream);
            }
            MVUtils.verifyLocale();
            String configFilePath = System.getProperty("user.dir") + File.separator + "CONFIG" + File.separator + "MViewer.cfg";
            File configFile = new File(configFilePath);
            if (configFile.exists()) {
                try {
                    FileInputStream fis = new FileInputStream(configFile);
                    CvPropertiesManager.loadPropertyValues(fis);
                    fis.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            String srConfigFilePath = System.getProperty("REPOSITORY_PATH", System.getProperty("user.dir", ".")) + File.separator + "Config" + File.separator + "SRConfig.xml";
            System.setProperty("SR_TMP_DIR", RedirectedStream.SR_TMP_DIR);
            File srConfigFile = new File(srConfigFilePath);
            if (srConfigFile.exists()) {
                System.setProperty("SR_CONFIG_FILE", srConfigFilePath);
            }
            System.setProperty("APP_IDENTIFIER", "MediaViewer");
            String language = System.getProperty("user.language");
            if (language.equalsIgnoreCase("ch") || language.equalsIgnoreCase("zh") || language.equalsIgnoreCase("ko")) {
                System.setProperty("ptk.sansserifBold", "SimSun");
            }
            if (language.equalsIgnoreCase("ja")) {
                System.setProperty("ptk.sansserifBold", "Dialog");
            }
            System.setProperty("loghandler", "null");
            Thread.setDefaultUncaughtExceptionHandler(new ThreadExceptionHandler());
            LookAndFeelUtil.setupLAF();
            System.err.println("MediaViewer application started");
            try {
                Class.forName("com.ge.med.StdAnno.DXApStyle");
                CvPropertiesManager.setProperty("cvf.annotation.apstyle.dx.DX.apstyleclass", "com.ge.med.StdAnno.DXApStyle");
                CvPropertiesManager.setProperty("cvf.annotation.apstyle.dx.XR.apstyleclass", "com.ge.med.StdAnno.DXApStyle");
                System.err.println(JAR_LOADED_MESSAGE);
            }
            catch (Exception e) {
                System.err.println(JAR_NOT_LOADED_MESSAGE);
            }
            XpPropertiesManager.setProperty("jami.render", "com.ge.med.terra.jami.render.XpPZWRenderer");
            XpPropertiesManager.setProperty("jami.maximagelayer.renderers", "10");
            XpPropertiesManager.setProperty("jami.noimage.message", CvUtils.getResourceBundle().getString("LOADING_MESSAGE"));
            if (language.equalsIgnoreCase("ch") || language.equalsIgnoreCase("zh") || language.equalsIgnoreCase("ko")) {
                XpPropertiesManager.setProperty("jami.noimage.fontname", "SimSun");
            }
            if (language.equalsIgnoreCase("ja")) {
                XpPropertiesManager.setProperty("jami.noimage.fontname", "Dialog");
            }
            XPopPanel.setProperties(CvPropertiesManager.getProperties());
            XpPropertiesManager.setProperty("jami.pixeladdressing", "center");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        service = Executors.newFixedThreadPool(1);
    }

    static class ScreenViewTypeHelper {
        ScreenViewTypeHelper() {
        }

        public void configScren(String name, final boolean isLoadCompleted, boolean isForcefulchange) {
            String suffix = ".views";
            String views = CvPropertiesManager.getProperty("screen." + name + suffix);
            final String[] allVies = views.split(",");
            int totalPort = screen.getNumPorts();
            if (isForcefulchange) {
                for (int i = 0; i < totalPort; ++i) {
                    ViewTypeCapable vtCap;
                    if (!(screen.getPort(i) instanceof ViewTypeCapable) || (vtCap = (ViewTypeCapable)((Object)screen.getPort(i))).getViewType().equals(allVies[i])) continue;
                    vtCap.setViewType(allVies[i]);
                }
            } else {
                for (int i = 0; i < allVies.length; ++i) {
                    ViewTypeCapable vtCap;
                    if (!(screen.getPort(i) instanceof ViewTypeCapable) || (vtCap = (ViewTypeCapable)((Object)screen.getPort(i))).getViewType().equalsIgnoreCase(allVies[i].trim())) continue;
                    final int toSet = i;
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            if (!isLoadCompleted) {
                                if (allVies[toSet].equals("3D")) {
                                    vtCap.setViewType("OBLIQUE");
                                } else if (!vtCap.getViewType().equals(allVies[toSet])) {
                                    vtCap.setViewType(allVies[toSet]);
                                }
                            }
                            if (isLoadCompleted && allVies[toSet].equals("3D")) {
                                vtCap.setViewType(allVies[toSet]);
                            }
                        }
                    };
                    CDViewerAppMain.swingSafe(runnable, false);
                }
            }
        }
    }

    public static class Toggle3DAction
    extends BaseAction {
        @Override
        public void setCapable(Capable cap) {
            super.setCapable(cap);
            ApplicationContext ac = ContextProvider.getApplicationContext("MediaViewer");
            if (ac != null) {
                ac.getApplication().addPropertyChangeListener(CDViewerAppMain.ENABLE_3D_MODE, new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        boolean state = (Boolean)evt.getNewValue();
                        Toggle3DAction.this.setEnabled(state);
                    }
                });
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ApplicationContext ac = ContextProvider.getApplicationContext("MediaViewer");
            if (ac.getApplication() instanceof CDViewerAppMain) {
                CDViewerAppMain app = (CDViewerAppMain)ac.getApplication();
                String mode = app.isAppMode3D() ? "MODE2D" : "MODE3D";
                app.switchAppMode(mode);
            }
        }

        @Override
        protected String getName() {
            return "Toggle3DAction";
        }
    }

    private class ScreenChangeListern
    implements PropertyChangeListener {
        private ScreenChangeListern() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            linkedDirector.disconnectAllViewports();
            final String str = evt.getNewValue().toString().replaceAll(" ", "");
            try {
                CDViewerAppMain.this.app_.getScreenloader().showScreen(str);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    CDViewerAppMain.this.cahcedLoader.loadVolumes(str, new J3DViewport[]{(J3DViewport)screen.getPort(0), (J3DViewport)screen.getPort(1), (J3DViewport)screen.getPort(2), (J3DViewport)screen.getPort(3)});
                    CDViewerAppMain.this.add3DDirector(false);
                    viewtypeHelper.configScren(str, true, true);
                    for (int i = 0; i < screen.getNumPorts(); ++i) {
                        XpViewport vp = (XpViewport)screen.getPort(i);
                        int toSet = i;
                        try {
                            CDViewerAppMain.this.helper.config(vp, "j3dvp" + toSet, CvPropertiesManager.getProperties());
                            linkedDirector.connectViewport(vp);
                            vp.refreshContents();
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    CDViewerAppMain.this.disableFusionSlider();
                    CDViewerAppMain.this.add3DDirector(CDViewerAppMain.this.is3DMode);
                    screen.selectAll();
                    CDViewerAppMain.this.sync3DportDFOV();
                }
            };
            service.submit(runnable);
        }
    }
}

