/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.tool;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class TraceInputStream
extends InputStream {
    private InputStream in;
    private FileOutputStream fout;

    public TraceInputStream(InputStream in, File tracefile) throws FileNotFoundException {
        this.in = in;
        this.fout = new FileOutputStream(tracefile);
    }

    public int read() throws IOException {
        int b = this.in.read();
        this.fout.write(b);
        return b;
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        int r = this.in.read(buf, off, len);
        if (r > 0) {
            this.fout.write(buf, off, r);
        }
        return r;
    }

    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public void close() throws IOException {
        this.in.close();
        this.fout.close();
    }

    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public void reset() throws IOException {
        this.in.reset();
    }

    public void mark(int n) {
        this.in.mark(n);
    }
}

