/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.tool;

import com.archimed.tool.IntHashtableEntry;
import com.archimed.tool.IntHashtableEnumerator;
import java.util.Enumeration;

public class IntHashtable {
    private IntHashtableEntry[] table;
    private int count;
    private int threshold;
    private float loadFactor;

    public IntHashtable(int initialCapacity, float loadFactor) {
        if (initialCapacity <= 0 || (double)loadFactor <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = loadFactor;
        this.table = new IntHashtableEntry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public IntHashtable(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntHashtable() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Enumeration keys() {
        return new IntHashtableEnumerator(this.table, true);
    }

    public Enumeration elements() {
        return new IntHashtableEnumerator(this.table, false);
    }

    public boolean contains(int value) {
        IntHashtableEntry[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            IntHashtableEntry e = tab[i];
            while (e != null) {
                if (e.value == value) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public boolean containsKey(int key) {
        IntHashtableEntry[] tab = this.table;
        int hash = key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        IntHashtableEntry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key == key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public int get(int key) {
        IntHashtableEntry[] tab = this.table;
        int hash = key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        IntHashtableEntry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key == key) {
                return e.value;
            }
            e = e.next;
        }
        return Integer.MAX_VALUE;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        IntHashtableEntry[] oldTable = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        IntHashtableEntry[] newTable = new IntHashtableEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newTable;
        int i = oldCapacity;
        while (i-- > 0) {
            IntHashtableEntry old = oldTable[i];
            while (old != null) {
                IntHashtableEntry e = old;
                old = old.next;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newTable[index];
                newTable[index] = e;
            }
        }
    }

    public int put(int key, int value) {
        IntHashtableEntry[] tab = this.table;
        int hash = key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        IntHashtableEntry e = null;
        e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key == key) {
                int old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(key, value);
        }
        e = new IntHashtableEntry();
        e.hash = hash;
        e.key = key;
        e.value = value;
        e.next = tab[index];
        tab[index] = e;
        ++this.count;
        return Integer.MAX_VALUE;
    }

    public int remove(int key) {
        IntHashtableEntry[] tab = this.table;
        int hash = key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        IntHashtableEntry e = tab[index];
        IntHashtableEntry prev = null;
        while (e != null) {
            if (e.hash == hash && e.key == key) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                return e.value;
            }
            prev = e;
            e = e.next;
        }
        return Integer.MAX_VALUE;
    }

    public synchronized void clear() {
        IntHashtableEntry[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }
}

