/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.log;

import com.archimed.log.JdtLogger;
import java.io.OutputStream;
import java.io.PrintStream;

public class DefaultJdtLogger
implements JdtLogger {
    public static final int ALL = 0;
    public static final int TRACE = 1;
    public static final int DEBUG = 2;
    public static final int INFO = 3;
    public static final int WARN = 4;
    public static final int ERROR = 5;
    public static final int FATAL = 6;
    public static final int OFF = 7;
    private static int level = 7;
    private static OutputStream out;
    private static PrintStream pout;
    private static final String DEFLEVEL_SYSPROP = "jdt.defaultjdtlogger.level";

    public static void setLevel(int level) {
        if (level < 0 || level > 7) {
            throw new IllegalArgumentException("invalid log level: " + level);
        }
        DefaultJdtLogger.level = level;
    }

    public static int getLevel() {
        return level;
    }

    public static void setOutputStream(OutputStream out) {
        DefaultJdtLogger.out = out;
        pout = new PrintStream(out, true);
    }

    public OutputStream getOutputStream() {
        return out;
    }

    public void fatal(Object msg) {
        if (level <= 6) {
            pout.println("FATAL " + msg);
        }
    }

    public void fatal(Object msg, Throwable t) {
        if (level <= 6) {
            pout.println("FATAL " + msg);
            this.printStackTrace(t);
        }
    }

    public void warn(Object msg) {
        if (level <= 4) {
            pout.println("WARN " + msg);
        }
    }

    public void warn(Object msg, Throwable t) {
        if (level <= 4) {
            pout.println("WARN " + msg);
            this.printStackTrace(t);
        }
    }

    public void debug(Object msg) {
        if (level <= 2) {
            pout.println("DEBUG " + msg);
        }
    }

    public void debug(Object msg, Throwable t) {
        if (level <= 2) {
            pout.println("DEBUG " + msg);
            this.printStackTrace(t);
        }
    }

    public void info(Object msg) {
        if (level <= 3) {
            pout.println("INFO " + msg);
        }
    }

    public void info(Object msg, Throwable t) {
        if (level <= 3) {
            pout.println("INFO " + msg);
            this.printStackTrace(t);
        }
    }

    public void error(Object msg) {
        if (level <= 5) {
            pout.println("ERROR " + msg);
        }
    }

    public void error(Object msg, Throwable t) {
        if (level <= 5) {
            pout.println("ERROR " + msg);
            this.printStackTrace(t);
        }
    }

    public void trace(Object msg) {
        if (level <= 1) {
            pout.println("TRACE " + msg);
        }
    }

    public void trace(Object msg, Throwable t) {
        if (level <= 1) {
            pout.println("TRACE " + msg);
            this.printStackTrace(t);
        }
    }

    public boolean isDebugEnabled() {
        return level <= 2;
    }

    public boolean isFatalEnabled() {
        return level <= 6;
    }

    public boolean isErrorEnabled() {
        return level <= 5;
    }

    public boolean isTraceEnabled() {
        return level <= 1;
    }

    public boolean isInfoEnabled() {
        return level <= 3;
    }

    public boolean isWarnEnabled() {
        return level <= 4;
    }

    private void printStackTrace(Throwable t) {
        t.printStackTrace(pout);
    }

    static {
        pout = System.out;
        SecurityManager secMgr = System.getSecurityManager();
        String level = "OFF";
        if (secMgr != null) {
            try {
                secMgr.checkPropertyAccess(DEFLEVEL_SYSPROP);
                level = System.getProperty(DEFLEVEL_SYSPROP, "OFF");
            }
            catch (SecurityException ex) {
                System.err.println("SecurityException when reading system property: jdt.defaultjdtlogger.level, log level set to OFF." + ex);
            }
        } else {
            level = System.getProperty(DEFLEVEL_SYSPROP, "OFF");
        }
        if (level.equals("DEBUG")) {
            DefaultJdtLogger.setLevel(2);
        } else if (level.equals("TRACE")) {
            DefaultJdtLogger.setLevel(1);
        } else if (level.equals("INFO")) {
            DefaultJdtLogger.setLevel(3);
        } else if (level.equals("WARN")) {
            DefaultJdtLogger.setLevel(4);
        } else if (level.equals("ERROR")) {
            DefaultJdtLogger.setLevel(5);
        } else if (level.equals("FATAL")) {
            DefaultJdtLogger.setLevel(6);
        }
    }
}

