/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.scu;

public class SCUProgressEvent {
    public static final int OPEN_SOCKET = 1;
    public static final int ASSOCIATE_REQUEST = 2;
    public static final int ASSOCIATE_RESPONSE = 3;
    public static final int C_ECHO_REQUEST = 4;
    public static final int C_ECHO_RESPONSE = 5;
    public static final int ASSOCIATE_RELEASE_REQUEST = 6;
    public static final int ASSOCIATE_RELEASE_RESPONSE = 7;
    public static final int CLOSE_SOCKET = 8;
    public static final int C_STORE_REQUEST = 9;
    public static final int C_STORE_RESPONSE = 10;
    public static final int C_FIND_REQUEST = 11;
    public static final int C_FIND_RESPONSE = 12;
    public static final int C_CANCEL_REQUEST = 13;
    public static final int C_MOVE_REQUEST = 14;
    public static final int C_MOVE_RESPONSE = 15;
    public static final int START = 1;
    public static final int END = 2;
    private int step;
    private int phase;

    public SCUProgressEvent(int step, int phase) {
        this.step = step;
        this.phase = phase;
    }

    public int getStep() {
        return this.step;
    }

    public int getPhase() {
        return this.phase;
    }

    public String getMessage() {
        String msg = this.phase == 1 ? "START " : "END ";
        switch (this.step) {
            case 1: {
                msg = msg + "OPEN SOCKET";
                break;
            }
            case 2: {
                msg = msg + "ASSOCIATE REQUEST";
                break;
            }
            case 3: {
                msg = msg + "ASSOCIATE RESPONSE";
                break;
            }
            case 4: {
                msg = msg + "C-ECHO REQUEST";
                break;
            }
            case 5: {
                msg = msg + "C-ECHO RESPONSE";
                break;
            }
            case 6: {
                msg = msg + "ASSOCIATE RELEASE REQUEST";
                break;
            }
            case 7: {
                msg = msg + "ASSOCIATE RELEASE RESPONSE";
                break;
            }
            case 8: {
                msg = msg + "CLOSE SOCKET";
                break;
            }
            case 9: {
                msg = msg + "C-STORE REQUEST";
                break;
            }
            case 10: {
                msg = msg + "C-STORE RESPONSE";
                break;
            }
            case 11: {
                msg = msg + "C-FIND REQUEST";
                break;
            }
            case 12: {
                msg = msg + "C-FIND RESPONSE";
                break;
            }
            case 13: {
                msg = msg + "C-CANCEL REQUEST";
                break;
            }
            case 14: {
                msg = msg + "C-MOVE REQUEST";
                break;
            }
            case 15: {
                msg = msg + "C-MOVE RESPONSE";
                break;
            }
            default: {
                msg = msg + "UNKNOWN";
            }
        }
        return msg;
    }

    public String toString() {
        return "SCUProgressEvent [" + this.getMessage() + "]";
    }
}

