/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.scu;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.DicomReader;
import com.archimed.dicom.Jdt;
import com.archimed.dicom.scu.AbstractCStoreItemRequest;
import com.archimed.dicom.scu.CStoreItemRequest;
import com.archimed.log.JdtLogger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileCStoreItemRequest
extends AbstractCStoreItemRequest {
    private File file;
    private boolean initialized = false;
    private static final JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(FileCStoreItemRequest.class);

    public FileCStoreItemRequest(File file) {
        super(null, null, null, file.getAbsolutePath());
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DicomObject readDicomObject() throws DicomException, IOException {
        DicomReader dicomReader = new DicomReader();
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(this.file);
            DicomObject dicomObject = dicomReader.read(inputStream);
            return dicomObject;
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {}
            }
        }
    }

    public long getSize() {
        return this.file.length();
    }

    public String getSopClass() {
        this.checkInitialized();
        return super.getSopClass();
    }

    public String getSopInstanceUID() {
        this.checkInitialized();
        return super.getSopInstanceUID();
    }

    public CStoreItemRequest.Status getStatus() {
        this.checkInitialized();
        return super.getStatus();
    }

    public Throwable getThrowable() {
        this.checkInitialized();
        return super.getThrowable();
    }

    public String getTransferSyntax() {
        this.checkInitialized();
        return super.getTransferSyntax();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInitialized() {
        block25: {
            if (this.initialized) {
                return;
            }
            BufferedInputStream inputStream = null;
            try {
                inputStream = new BufferedInputStream(new FileInputStream(this.file));
                inputStream.mark(150);
                DicomReader dicomReader = new DicomReader();
                boolean isDicomFile = dicomReader.checkIfDicomFile(inputStream);
                if (!isDicomFile) {
                    this.setStatus(NODICOM);
                    return;
                }
                inputStream.reset();
                DicomObject dataset = dicomReader.read(inputStream, false);
                DicomObject fileMetaInfo = dataset.getFileMetaInformation();
                if (fileMetaInfo == null) {
                    throw new DicomException("not a dicom part 10 file");
                }
                if (fileMetaInfo.getSize(31) <= 0) {
                    throw new DicomException("Transfer Syntax missing in file meta information");
                }
                this.transferSyntax = fileMetaInfo.getString(31, 0);
                if (fileMetaInfo.getSize(31) <= 0) {
                    throw new DicomException("SOP Class UID missing in file meta information");
                }
                this.sopClass = fileMetaInfo.getString(29, 0);
                if (fileMetaInfo.getSize(30) > 0) {
                    this.sopInstanceUID = fileMetaInfo.getString(30, 0);
                    break block25;
                }
                throw new DicomException("SOP Instance UID missing in file meta information");
            }
            catch (IOException e) {
                this.setStatus(EXCEPTION);
                this.setThrowable(e);
            }
            catch (DicomException e) {
                this.setStatus(EXCEPTION);
                this.setThrowable(e);
            }
            finally {
                this.initialized = true;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    public File getFile() {
        return this.file;
    }
}

