/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.scu;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.DicomReader;
import com.archimed.dicom.DumpUtils;
import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.Jdt;
import com.archimed.dicom.SOPClassUID;
import com.archimed.dicom.TransferSyntaxUID;
import com.archimed.dicom.UID;
import com.archimed.dicom.UnknownUIDException;
import com.archimed.dicom.network.Acknowledge;
import com.archimed.dicom.network.AssociationIO;
import com.archimed.dicom.network.Command;
import com.archimed.dicom.network.Request;
import com.archimed.dicom.network.ResponsePolicy;
import com.archimed.dicom.network.ULServiceMessage;
import com.archimed.dicom.scu.CStoreItemRequest;
import com.archimed.dicom.scu.CStoreSCU;
import com.archimed.dicom.scu.DatasetCStoreItemRequest;
import com.archimed.dicom.scu.FileCStoreItemRequest;
import com.archimed.dicom.scu.MultiCStoreSCU;
import com.archimed.dicom.scu.SCUException;
import com.archimed.dicom.scu.SCUFactory;
import com.archimed.dicom.scu.impl.BasicMultiCStoreSCU;
import com.archimed.log.JdtLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class CStoreSCUFactory
extends SCUFactory {
    protected static JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(CStoreSCUFactory.class);

    public static void main(String[] args) {
        try {
            log.debug("Trispark JDT Version: " + Jdt.getVersion() + "(" + Jdt.getBuild() + ")");
            Command cmd = CStoreSCUFactory.executeCStore(args[0], Integer.parseInt(args[1]), args[2], args[3], args[4]);
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
            log.error("Exception while executing C-STORE: " + t, t);
        }
    }

    public static Command executeCStore(String host, int port, String callingAE, String calledAE, String file) throws SCUException, DicomException, IOException {
        DicomObject meta;
        FileInputStream fin = new FileInputStream(file);
        DicomReader dcmReader = new DicomReader();
        DicomObject dataset = dcmReader.read(fin, true);
        fin.close();
        if (log.isDebugEnabled()) {
            DumpUtils dmpUtils = new DumpUtils(true, false);
            StringBuffer sb = new StringBuffer();
            dmpUtils.dump(dataset, sb);
            log.debug("DUMP DICOMFILE:");
            log.debug("\r\n" + sb.toString());
        }
        if ((meta = dataset.getFileMetaInformation()) == null) {
            throw new SCUException("No file meta information");
        }
        String s = meta.getString(31, 0);
        if (s == null) {
            throw new SCUException("No specified transfer syntax in file meta information");
        }
        TransferSyntaxUID transferSyntaxUID = null;
        try {
            transferSyntaxUID = (TransferSyntaxUID)UID.getUIDEntry(s);
        }
        catch (UnknownUIDException ex) {
            throw new SCUException("Unknown transfer syntax in file meta information: '" + s + "'");
        }
        return CStoreSCUFactory.executeCStore(host, port, callingAE, calledAE, dataset, transferSyntaxUID);
    }

    public static Command executeCStore(String host, int port, String callingAE, String calledAE, DicomObject dataset, TransferSyntaxUID transferSyntaxUID) throws SCUException, IOException {
        try {
            String sopClass = dataset.getString(62, 0);
            String sopInstance = dataset.getString(63, 0);
            SOPClassUID sopClassUID = null;
            try {
                sopClassUID = (SOPClassUID)UID.getUIDEntry(sopClass);
            }
            catch (UnknownUIDException ex) {
                log.error("UnknownUIDException while executing C-STORE", ex);
                throw new SCUException("UnknownUIDException while executing C-STORE: + ex", ex);
            }
            CStoreSCU cStoreSCU = CStoreSCUFactory.createCStoreSCU(host, port, callingAE, calledAE, sopClassUID, transferSyntaxUID);
            Command cmd = cStoreSCU.cstore(dataset, 0);
            CStoreSCUFactory.release(cStoreSCU.getAssociationIO());
            return cmd;
        }
        catch (DicomException ex) {
            log.error("DicomException while executing C-STORE: " + ex, ex);
            throw new SCUException("DicomException while executing C-STORE: + ex", ex);
        }
    }

    public static CStoreSCU createCStoreSCU(String host, int port, String callingAE, String calledAE, SOPClassUID sopClassUID, TransferSyntaxUID transferSyntaxUID) throws SCUException, IOException {
        Socket socket = new Socket(host, port);
        return CStoreSCUFactory.createCStoreSCU(socket, callingAE, calledAE, sopClassUID, transferSyntaxUID);
    }

    public static CStoreSCU createCStoreSCU(Socket socket, String callingAE, String calledAE, SOPClassUID sopClassUID, TransferSyntaxUID transferSyntaxUID) throws SCUException, IOException {
        AssociationIO associationIO = new AssociationIO(socket.getInputStream(), socket.getOutputStream());
        Request request = new Request();
        request.setCalledTitle(calledAE);
        request.setCallingTitle(callingAE);
        try {
            request.addPresentationContext(1, sopClassUID.getConstant(), new int[]{transferSyntaxUID.getConstant()});
        }
        catch (IllegalValueException ex) {
            log.error("IllegalValueException while adding presentation context: " + ex, ex);
            throw new SCUException("IllegalValueException while adding presentation context: " + ex, ex);
        }
        request.setMaxPduSize(32768);
        log.debug(request);
        try {
            associationIO.write(request);
        }
        catch (DicomException ex) {
            log.error("DicomException while writing Association Request: " + ex, ex);
            throw new SCUException("DicomException while writing Association Request: " + ex, ex);
        }
        ULServiceMessage ulServiceMessage = null;
        try {
            ulServiceMessage = associationIO.read();
        }
        catch (DicomException ex) {
            log.error("DicomException while reading Association Response: " + ex, ex);
            throw new SCUException("DicomException while writing Association Response: " + ex, ex);
        }
        log.debug(ulServiceMessage);
        switch (ulServiceMessage.getMessageType()) {
            case 1002: {
                int result;
                Acknowledge acknowledge = (Acknowledge)ulServiceMessage;
                try {
                    result = ResponsePolicy.getResultForAbstractSyntax(request, acknowledge, sopClassUID.getConstant());
                }
                catch (IllegalValueException ex) {
                    log.error("IllegalValueException while calling getResultForAbstractSyntax: " + ex, ex);
                    throw new SCUException("IllegalValueException while calling getResultForAbstractSyntax: " + ex);
                }
                if (result == 0) {
                    return new CStoreSCU(associationIO, 1, sopClassUID);
                }
                throw new SCUException("association acknowledge received but presentation context not accepted");
            }
            case 1003: {
                log.error("association reject received: " + ulServiceMessage);
                throw new SCUException("association reject received: " + ulServiceMessage);
            }
            case 1007: {
                log.error("abort received: " + ulServiceMessage);
                throw new SCUException("abort received: " + ulServiceMessage);
            }
        }
        log.error("unexpected pdu received: " + ulServiceMessage);
        throw new SCUException("unexpected pdu received: " + ulServiceMessage);
    }

    public static MultiCStoreSCU createMultiCStoreSCU(String host, int port, String calledAETitle, String localAETitle, File file, boolean recurse) {
        return CStoreSCUFactory.createMultiCStoreSCU(host, port, calledAETitle, localAETitle, new File[]{file}, recurse);
    }

    public static MultiCStoreSCU createMultiCStoreSCU(String host, int port, String calledAETitle, String localAETitle, File[] files, boolean recurse) {
        List fileList = new ArrayList();
        for (int i = 0; i < files.length; ++i) {
            fileList = CStoreSCUFactory.getInputFiles(fileList, files[i], recurse);
        }
        CStoreItemRequest[] itemRequests = new CStoreItemRequest[fileList.size()];
        for (int i = 0; i < fileList.size(); ++i) {
            itemRequests[i] = new FileCStoreItemRequest((File)fileList.get(i));
        }
        return CStoreSCUFactory.createMultiCStoreSCU(host, port, calledAETitle, localAETitle, itemRequests);
    }

    public static MultiCStoreSCU createMultiCStoreSCU(String host, int port, String calledAETitle, String localAETitle, DicomObject dataset) {
        return CStoreSCUFactory.createMultiCStoreSCU(host, port, calledAETitle, localAETitle, new DicomObject[]{dataset});
    }

    public static MultiCStoreSCU createMultiCStoreSCU(String host, int port, String calledAETitle, String localAETitle, DicomObject[] datasets) {
        CStoreItemRequest[] itemRequests = new CStoreItemRequest[datasets.length];
        for (int i = 0; i < datasets.length; ++i) {
            itemRequests[i] = new DatasetCStoreItemRequest(datasets[i]);
        }
        return CStoreSCUFactory.createMultiCStoreSCU(host, port, calledAETitle, localAETitle, itemRequests);
    }

    public static MultiCStoreSCU createMultiCStoreSCU(String host, int port, String calledAETitle, String localAETitle, CStoreItemRequest[] itemRequests) {
        return new BasicMultiCStoreSCU(host, port, calledAETitle, localAETitle, itemRequests);
    }

    private static List getInputFiles(List list, File inputFile, boolean recurse) {
        if (inputFile.isFile()) {
            list.add(inputFile);
        } else if (recurse) {
            File[] children = inputFile.listFiles();
            Arrays.sort(children, new Comparator(){

                public int compare(Object o1, Object o2) {
                    File f1 = (File)o1;
                    File f2 = (File)o2;
                    if (f1.isFile() && f2.isDirectory()) {
                        return -1;
                    }
                    if (f1.isDirectory() && f2.isFile()) {
                        return 1;
                    }
                    return ((File)o1).getName().compareToIgnoreCase(((File)o2).getName());
                }
            });
            for (int i = 0; i < children.length; ++i) {
                File child = children[i];
                CStoreSCUFactory.getInputFiles(list, child, recurse);
            }
        }
        return list;
    }
}

