/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.scu;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.Jdt;
import com.archimed.dicom.SOPClassUID;
import com.archimed.dicom.network.Acknowledge;
import com.archimed.dicom.network.AssociationIO;
import com.archimed.dicom.network.Request;
import com.archimed.dicom.network.ResponsePolicy;
import com.archimed.dicom.network.ULServiceMessage;
import com.archimed.dicom.scu.CFindSCU;
import com.archimed.dicom.scu.MultiCFindSCU;
import com.archimed.dicom.scu.SCUException;
import com.archimed.dicom.scu.SCUFactory;
import com.archimed.dicom.scu.impl.BasicMultiCFindSCU;
import com.archimed.log.JdtLogger;
import java.io.IOException;
import java.net.Socket;
import java.util.Collection;

public class CFindSCUFactory
extends SCUFactory {
    protected static JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(CFindSCUFactory.class);

    public static Collection executeCFind(String host, int port, String calledAE, String callingAE, SOPClassUID sopClassUID, DicomObject identifier, CFindSCU.ResponseHandler handler) throws SCUException, IOException {
        CFindSCU cFindSCU = CFindSCUFactory.createCFindSCU(host, port, callingAE, calledAE, sopClassUID);
        try {
            Collection list = cFindSCU.cfind(identifier, 0, handler);
            CFindSCUFactory.release(cFindSCU.getAssociationIO());
            return list;
        }
        catch (DicomException ex) {
            log.error("DicomException while executing C-FIND: " + ex, ex);
            throw new SCUException("DicomException while executing C-FIND: + ex", ex);
        }
    }

    public static CFindSCU createCFindSCU(String host, int port, String callingAE, String calledAE, SOPClassUID sopClassUID) throws SCUException, IOException {
        Socket socket = new Socket(host, port);
        return CFindSCUFactory.createCFindSCU(socket, callingAE, calledAE, sopClassUID);
    }

    public static CFindSCU createCFindSCU(Socket socket, String callingAE, String calledAE, SOPClassUID sopClassUID) throws SCUException, IOException {
        AssociationIO associationIO = new AssociationIO(socket.getInputStream(), socket.getOutputStream());
        Request request = new Request();
        request.setCalledTitle(calledAE);
        request.setCallingTitle(callingAE);
        try {
            request.addPresentationContext(1, sopClassUID.getConstant(), new int[]{8193});
        }
        catch (IllegalValueException ex) {
            log.error("IllegalValueException while adding presentation context: " + ex, ex);
            throw new SCUException("IllegalValueException while adding presentation context: " + ex, ex);
        }
        request.setMaxPduSize(32768);
        try {
            associationIO.write(request);
        }
        catch (DicomException ex) {
            log.error("DicomException while writing Association Request: " + ex, ex);
            throw new SCUException("DicomException while writing Association Request: " + ex, ex);
        }
        ULServiceMessage ulServiceMessage = null;
        try {
            ulServiceMessage = associationIO.read();
        }
        catch (DicomException ex) {
            log.error("DicomException while reading Association Response: " + ex, ex);
            throw new SCUException("DicomException while writing Association Response: " + ex, ex);
        }
        switch (ulServiceMessage.getMessageType()) {
            case 1002: {
                int result;
                Acknowledge acknowledge = (Acknowledge)ulServiceMessage;
                try {
                    result = ResponsePolicy.getResultForAbstractSyntax(request, acknowledge, sopClassUID.getConstant());
                }
                catch (IllegalValueException ex) {
                    log.error("IllegalValueException while calling getResultForAbstractSyntax: " + ex, ex);
                    throw new SCUException("IllegalValueException while calling getResultForAbstractSyntax: " + ex);
                }
                if (result == 0) {
                    return new CFindSCU(associationIO, 1, sopClassUID);
                }
                throw new SCUException("association acknwowledge received but presentation context not accepted");
            }
            case 1003: {
                log.error("association reject received: " + ulServiceMessage);
                throw new SCUException("association reject received: " + ulServiceMessage);
            }
            case 1007: {
                log.error("abort received: " + ulServiceMessage);
                throw new SCUException("abort received: " + ulServiceMessage);
            }
        }
        log.error("unexpected pdu received: " + ulServiceMessage);
        throw new SCUException("unexpected pdu received: " + ulServiceMessage);
    }

    public static MultiCFindSCU createMultiCFindSCU(String host, int port, String calledAETitle, String localAETitle) {
        return new BasicMultiCFindSCU(host, port, calledAETitle, localAETitle);
    }

    public static MultiCFindSCU createMultiCFindSCU(String host, int port, String calledAETitle, String localAETitle, SOPClassUID sopClassUID) {
        return new BasicMultiCFindSCU(host, port, calledAETitle, localAETitle, sopClassUID);
    }
}

