/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.scu;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.Jdt;
import com.archimed.dicom.SOPClassUID;
import com.archimed.dicom.network.Abort;
import com.archimed.dicom.network.AssociationIO;
import com.archimed.dicom.network.Command;
import com.archimed.dicom.network.Dimse;
import com.archimed.dicom.network.PduException;
import com.archimed.dicom.network.ReleaseRequest;
import com.archimed.dicom.network.StatusCode;
import com.archimed.dicom.network.ULServiceMessage;
import com.archimed.dicom.scu.SCUException;
import com.archimed.dicom.scu.SCUFactory;
import com.archimed.log.JdtLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CFindSCU {
    protected JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(CFindSCU.class);
    private AssociationIO associationIO;
    private SOPClassUID sopClassUID;
    private int presentationContextID;
    private Command findreq = null;
    private boolean canceled = false;

    public CFindSCU(AssociationIO associationIO, int presentationContextID, SOPClassUID sopClassUID) {
        this.associationIO = associationIO;
        this.presentationContextID = presentationContextID;
        this.sopClassUID = sopClassUID;
    }

    public AssociationIO getAssociationIO() {
        return this.associationIO;
    }

    public Collection cfind(DicomObject identifier, int priority, ResponseHandler handler) throws SCUException, DicomException, IOException {
        ULServiceMessage ulServiceMessage;
        int messageID = SCUFactory.getMessageID();
        Command findreq = Command.createCFindReq(messageID, this.sopClassUID.getConstant(), priority);
        Dimse dimse = new Dimse(this.presentationContextID, findreq, identifier);
        this.associationIO.write(dimse);
        this.findreq = findreq;
        ArrayList list = new ArrayList();
        block4: while (true) {
            ulServiceMessage = this.associationIO.read();
            switch (ulServiceMessage.getMessageType()) {
                case 1004: {
                    boolean end;
                    if (!(end = this.handleCFindResponse(list, (Dimse)ulServiceMessage, handler))) continue block4;
                    return list;
                }
                case 1007: {
                    this.log.error("abort received when expecting dimse: " + ulServiceMessage);
                    throw new SCUException("abort received when expecting dimse: " + ulServiceMessage);
                }
            }
            break;
        }
        this.log.error("unexpected pdu received when expecting dimse: " + ulServiceMessage);
        throw new SCUException("unexpected pdu received when expecting dimse: " + ulServiceMessage);
    }

    public void ccancelfind() throws SCUException, DicomException, IOException {
        if (this.findreq == null) {
            this.log.error("error sending C-CANCEL-FIND: unable to cancel before C-FIND request has been sent");
            new SCUException("error sending C-CANCEL-FIND: unable to cancel before C-FIND request has been sent");
        }
        Command ccancelfindreq = Command.createCCancel(this.findreq);
        Dimse dimse = new Dimse(this.presentationContextID, ccancelfindreq, null);
        this.associationIO.write(dimse);
        this.canceled = true;
    }

    private boolean handleCFindResponse(List list, Dimse dimse, ResponseHandler handler) throws IOException, DicomException, SCUException {
        Command cmd = dimse.getCommand();
        if (cmd.getCommandType() != 32800) {
            this.log.error("unexpected response command received: " + cmd.getCommandName() + ", aborting");
            this.associationIO.write(new Abort(Abort.DICOM_UL_SERVICE_USER, Abort.REASON_NOT_SPECIFIED));
            throw new SCUException("unexpected response command received: " + cmd.getCommandName() + ", aborting");
        }
        StatusCode statusCode = StatusCode.forCFIND(cmd.getStatus());
        if (statusCode.isSuccess()) {
            handler.success(dimse);
            this.log.debug("received success C-FIND response");
            return true;
        }
        if (statusCode.isPending()) {
            handler.pending(dimse);
            if (!this.canceled) {
                this.log.debug("received pending C-FIND response, adding response dataset to collection");
                list.add(dimse.getDataSet());
            } else {
                this.log.debug("received pending C-FIND response when already canceled, omitting response dataset from collection");
            }
            return false;
        }
        if (statusCode.isFailure()) {
            handler.failed(dimse);
            return true;
        }
        if (statusCode.isCancel()) {
            handler.canceled(dimse);
            if (this.canceled) {
                return true;
            }
            this.log.error("unexpected status of canceled in C-FIND response");
            return true;
        }
        if (statusCode.isUnknown()) {
            this.log.error("unknown status code returned for C-FIND: " + statusCode + ",aborting");
            this.associationIO.write(new Abort(Abort.DICOM_UL_SERVICE_USER, Abort.REASON_NOT_SPECIFIED));
            return true;
        }
        this.log.error("internal error: code should not reach this point");
        throw new SCUException("internal error: code should not reach this point");
    }

    public void close() throws DicomException, IOException, PduException, SCUException {
        this.associationIO.write(new ReleaseRequest());
        ULServiceMessage message = this.associationIO.read();
        if (message.getMessageType() != 1006) {
            throw new SCUException("unexpected release response message: " + message.getMessageType());
        }
    }

    public static interface ResponseHandler {
        public void pending(Dimse var1);

        public void success(Dimse var1);

        public void failed(Dimse var1);

        public void canceled(Dimse var1);
    }
}

