/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.UnknownUIDException;
import com.archimed.dicom.network.SubItem;
import com.archimed.dicom.network.UserIdentityNegotiationResponse;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

class UserIdentityNegotiationResponseSubItem
extends SubItem {
    int itemtype = 88;
    private UserIdentityNegotiationResponse userIdentityNegotiationResponse;

    public UserIdentityNegotiationResponseSubItem() {
    }

    UserIdentityNegotiationResponseSubItem(UserIdentityNegotiationResponse userIdentityNegotiationResponse) {
        this.userIdentityNegotiationResponse = userIdentityNegotiationResponse;
    }

    public int getLength() {
        return 6 + this.userIdentityNegotiationResponse.getServerResponse().length;
    }

    public void write(DataOutputStream out) throws IOException {
        out.write(this.itemtype);
        out.write(0);
        out.writeChar(this.getLength() - 4);
        out.writeChar(this.userIdentityNegotiationResponse.getServerResponse().length);
        out.write(this.userIdentityNegotiationResponse.getServerResponse());
    }

    public int read(DataInputStream in) throws IOException, IllegalValueException, UnknownUIDException {
        int b = in.read();
        if (b != this.itemtype) {
            throw new IllegalValueException("itemtype field of received UserIdentityNegotiationResponseSubItem  not " + this.itemtype);
        }
        in.read();
        char length = in.readChar();
        byte[] buf = new byte[length];
        in.readFully(buf);
        DataInputStream rest = new DataInputStream(new ByteArrayInputStream(buf));
        char fieldLen = rest.readChar();
        byte[] serverResponse = new byte[fieldLen];
        rest.readFully(serverResponse);
        this.userIdentityNegotiationResponse = new UserIdentityNegotiationResponse(serverResponse);
        return length + 4;
    }

    public UserIdentityNegotiationResponse getUserIdentityNegotiationResponse() {
        return this.userIdentityNegotiationResponse;
    }
}

