/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

public class UserIdentityNegotiationRequest {
    public static final int TYPE_USERNAME = 1;
    public static final int TYPE_USERNAME_PASSWORD = 2;
    public static final int TYPE_KERBEROS = 3;
    public static final int TYPE_SAML = 4;
    private int userIdentityType;
    private boolean positiveResponseRequested;
    private byte[] userIdentity;
    private byte[] passCode;

    public UserIdentityNegotiationRequest(int userIdentityType, boolean positiveResponseRequested, byte[] userIdentity) {
        this(userIdentityType, positiveResponseRequested, userIdentity, null);
    }

    public UserIdentityNegotiationRequest(int userIdentityType, boolean positiveResponseRequested, byte[] userIdentity, byte[] passCode) {
        this.userIdentityType = userIdentityType;
        this.positiveResponseRequested = positiveResponseRequested;
        this.userIdentity = userIdentity;
        this.passCode = passCode;
    }

    public int getUserIdentityType() {
        return this.userIdentityType;
    }

    public String getUserIdentityTypeString() {
        switch (this.userIdentityType) {
            case 1: {
                return "Username";
            }
            case 2: {
                return "Username and passcode";
            }
            case 3: {
                return "Kerberos";
            }
            case 4: {
                return "SAML";
            }
        }
        return "-";
    }

    public boolean isPositiveResponseRequested() {
        return this.positiveResponseRequested;
    }

    public byte[] getUserIdentity() {
        return this.userIdentity;
    }

    public byte[] getPassCode() {
        return this.passCode;
    }
}

