/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

public class StatusCode {
    private static final int SUCCESS = 0;
    private static final int PENDING = 1;
    private static final int CANCEL = 2;
    private static final int FAILED = 3;
    private static final int WARNING = 4;
    private static final int UNKNOWN = 5;
    private int code;
    private int statusclass;
    private String furtherMeaning;

    StatusCode(int code, int statusclass, String furtherMeaning) {
        this.code = code;
        this.statusclass = statusclass;
        this.furtherMeaning = furtherMeaning;
    }

    public boolean isSuccess() {
        return this.statusclass == 0;
    }

    public boolean isPending() {
        return this.statusclass == 1;
    }

    public boolean isFailure() {
        return this.statusclass == 3;
    }

    public boolean isWarning() {
        return this.statusclass == 4;
    }

    public boolean isCancel() {
        return this.statusclass == 2;
    }

    public boolean isUnknown() {
        return this.statusclass == 5;
    }

    public String getDescription() {
        return this.furtherMeaning;
    }

    public static StatusCode forCFIND(int code) {
        if (code == 0) {
            return new StatusCode(code, 0, "Matching is complete - No final identifier is supplied");
        }
        if (code == 42752) {
            return new StatusCode(code, 3, "Out of Resources");
        }
        if (code == 43264) {
            return new StatusCode(code, 3, "Identifier does not match SOP Class");
        }
        if (code >= 49152 && code <= 53247) {
            return new StatusCode(code, 3, "Unable to process");
        }
        if (code == 65024) {
            return new StatusCode(code, 2, "Matching terminated due to Cancel request");
        }
        if (code == 65280) {
            return new StatusCode(code, 1, "Matches are continuing");
        }
        if (code == 65281) {
            return new StatusCode(code, 1, "Matches are continuing - Warning: one or more optional keys not supported for existence and/or matching");
        }
        return new StatusCode(code, 5, "Unknown status code for C-FIND: " + code);
    }

    public static StatusCode forCMove(int code) {
        if (code == 0) {
            return new StatusCode(code, 0, "Sub-operations Complete - No Failures");
        }
        if (code == 42753) {
            return new StatusCode(code, 3, "Out of Resources - Unable to calculate number of matches");
        }
        if (code == 42754) {
            return new StatusCode(code, 3, "Out of Resources - Unable to perform sub-operations");
        }
        if (code == 43009) {
            return new StatusCode(code, 3, "Move Destination unknown");
        }
        if (code == 43264) {
            return new StatusCode(code, 3, "Identifier does not match SOP Class");
        }
        if (code >= 49152 && code <= 53247) {
            return new StatusCode(code, 3, "Unable to Process");
        }
        if (code == 65024) {
            return new StatusCode(code, 2, "Sub-operations terminated due to Cancel indication");
        }
        if (code == 45056) {
            return new StatusCode(code, 4, "Sub-operations complete - One or more Failures");
        }
        if (code == 65280) {
            return new StatusCode(code, 1, "Sub-operations are continuing");
        }
        return new StatusCode(code, 5, "Unknown status code for C-MOVE: " + code);
    }

    public static StatusCode forCStore(int code) {
        if (code == 0) {
            return new StatusCode(code, 0, "Success");
        }
        if (code >= 42752 && code <= 43007) {
            return new StatusCode(code, 3, "Refused: Out of Resources");
        }
        if (code >= 43264 && code <= 43007) {
            return new StatusCode(code, 3, "Error: Data Set does not match SOP Class");
        }
        if (code >= 49152 && code <= 53247) {
            return new StatusCode(code, 3, "Error: Cannot understand");
        }
        if (code == 45056) {
            return new StatusCode(code, 4, "Coercion of Data Elements");
        }
        if (code == 45063) {
            return new StatusCode(code, 4, "Data Set does not match SOP Class");
        }
        if (code == 45062) {
            return new StatusCode(code, 4, "Elements Discarded");
        }
        return new StatusCode(code, 5, "Unknown status code for C-STORE: " + Integer.toHexString(code).toUpperCase());
    }

    public int getCode() {
        return this.code;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        if (this.code == 0) {
            sb.append(" SUCCESS");
        } else if (this.code == 3) {
            sb.append(" FAILED");
        } else if (this.code == 4) {
            sb.append(" WARNING");
        } else if (this.code == 1) {
            sb.append(" PENDING");
        } else if (this.code == 5) {
            sb.append(" UNKNOWN");
        } else if (this.code == 2) {
            sb.append(" CANCEL");
        }
        sb.append(" (");
        sb.append(Integer.toHexString(this.code).toUpperCase());
        sb.append(") ");
        sb.append(this.furtherMeaning);
        sb.append("]");
        return sb.toString();
    }
}

