/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.SOPClassUID;
import com.archimed.dicom.TransferSyntaxUID;
import com.archimed.dicom.UID;
import com.archimed.dicom.UIDEntry;
import com.archimed.dicom.network.Acknowledge;
import com.archimed.dicom.network.Reject;
import com.archimed.dicom.network.Request;
import com.archimed.dicom.network.Response;

public class ResponsePolicy {
    public static Response prepareResponse(Request request, String calledtitle, String[] callingtitles, int[] asids, int tsid, boolean rejectnocontext) throws IllegalValueException {
        return ResponsePolicy.prepareResponse(request, calledtitle, callingtitles, asids, new int[]{tsid}, rejectnocontext);
    }

    public static Response prepareResponse(Request request, String calledtitle, String[] callingtitles, int[] asids, int[] tsids, boolean rejectnocontext) throws IllegalValueException {
        int i;
        if (calledtitle != null && !request.getCalledTitle().equals(calledtitle)) {
            return new Reject(Reject.REJECTED_PERMANENT, Reject.DICOM_UL_SERVICE_USER, Reject.USER_CALLED_AETITLE_NOT_RECOGNIZED);
        }
        boolean reject = true;
        if (callingtitles != null) {
            for (int i2 = 0; i2 < callingtitles.length; ++i2) {
                if (!request.getCallingTitle().equals(callingtitles[i2])) continue;
                reject = false;
            }
            if (reject) {
                return new Reject(Reject.REJECTED_PERMANENT, Reject.DICOM_UL_SERVICE_USER, Reject.USER_CALLING_AETITLE_NOT_RECOGNIZED);
            }
        }
        Acknowledge ack = new Acknowledge();
        ack.setCalledTitle(request.getCalledTitle());
        ack.setCallingTitle(request.getCallingTitle());
        block1: for (i = 0; i < request.getPresentationContexts(); ++i) {
            UIDEntry asentry = request.getAbstractSyntax(i);
            for (int j = 0; j < asids.length; ++j) {
                if (!asentry.equals(UID.getUIDEntry(asids[j]))) continue;
                for (int k = 0; k < request.getTransferSyntaxes(i); ++k) {
                    UIDEntry tsentry = request.getTransferSyntax(i, k);
                    for (int l = 0; l < tsids.length; ++l) {
                        if (tsentry.getConstant() != tsids[l]) continue;
                        ack.addPresentationContext(request.getID(i), 0, tsids[l]);
                        continue block1;
                    }
                }
                ack.addPresentationContext(request.getID(i), 4, 8193);
                continue block1;
            }
            ack.addPresentationContext(request.getID(i), 3, 8193);
        }
        if (rejectnocontext) {
            reject = true;
            for (i = 0; i < ack.getPresentationContexts(); ++i) {
                if (ack.getResult(i) != 0) continue;
                reject = false;
            }
            if (reject) {
                return new Reject(Reject.REJECTED_PERMANENT, Reject.DICOM_UL_SERVICE_USER, Reject.USER_NO_REASON_GIVEN);
            }
        }
        return ack;
    }

    public static Response prepareResponse(Request request, String calledtitle, String[] callingtitles, SupportedContext[] contexts, boolean rejectnocontext) throws IllegalValueException {
        int i;
        if (calledtitle != null && !request.getCalledTitle().equals(calledtitle)) {
            return new Reject(Reject.REJECTED_PERMANENT, Reject.DICOM_UL_SERVICE_USER, Reject.USER_CALLED_AETITLE_NOT_RECOGNIZED);
        }
        boolean reject = true;
        if (callingtitles != null) {
            for (int i2 = 0; i2 < callingtitles.length; ++i2) {
                if (!request.getCallingTitle().equals(callingtitles[i2])) continue;
                reject = false;
            }
            if (reject) {
                return new Reject(Reject.REJECTED_PERMANENT, Reject.DICOM_UL_SERVICE_USER, Reject.USER_CALLING_AETITLE_NOT_RECOGNIZED);
            }
        }
        Acknowledge ack = new Acknowledge();
        ack.setCalledTitle(request.getCalledTitle());
        ack.setCallingTitle(request.getCallingTitle());
        block1: for (i = 0; i < request.getPresentationContexts(); ++i) {
            UIDEntry asentry = request.getAbstractSyntax(i);
            for (int j = 0; j < contexts.length; ++j) {
                if (!asentry.equals(contexts[j].sopClassUID)) continue;
                for (int k = 0; k < request.getTransferSyntaxes(i); ++k) {
                    UIDEntry tsentry = request.getTransferSyntax(i, k);
                    for (int l = 0; l < contexts[j].tsUIDs.length; ++l) {
                        if (!tsentry.equals(contexts[j].tsUIDs[l])) continue;
                        ack.addPresentationContext(request.getID(i), 0, contexts[j].tsUIDs[l].getConstant());
                        continue block1;
                    }
                }
                ack.addPresentationContext(request.getID(i), 4, 8193);
                continue block1;
            }
            ack.addPresentationContext(request.getID(i), 3, 8193);
        }
        if (rejectnocontext) {
            reject = true;
            for (i = 0; i < ack.getPresentationContexts(); ++i) {
                if (ack.getResult(i) != 0) continue;
                reject = false;
            }
            if (reject) {
                return new Reject(Reject.REJECTED_PERMANENT, Reject.DICOM_UL_SERVICE_USER, Reject.USER_NO_REASON_GIVEN);
            }
        }
        return ack;
    }

    public static int getResultForAbstractSyntax(Request request, Acknowledge ack, int asid) throws IllegalValueException {
        int n = request.getPresentationContexts();
        for (int i = 0; i < n; ++i) {
            UIDEntry asentry = request.getAbstractSyntax(i);
            if (asentry.getConstant() != asid) continue;
            int pcid_sender = request.getID(i);
            for (int j = 0; j < ack.getPresentationContexts(); ++j) {
                int pcid_receiver = ack.getID(j);
                if (pcid_sender != pcid_receiver) continue;
                return ack.getResult(j);
            }
            throw new IllegalValueException("no matching presentation context id in request and acknowledge for specified abstract syntax");
        }
        throw new IllegalValueException("abstract syntax not in request");
    }

    public static class SupportedContext {
        SOPClassUID sopClassUID;
        TransferSyntaxUID[] tsUIDs;

        public SupportedContext(SOPClassUID sopClassUID, TransferSyntaxUID[] tsUIDs) {
            this.sopClassUID = sopClassUID;
            this.tsUIDs = tsUIDs;
        }
    }
}

