/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

import com.archimed.dicom.network.Response;
import com.archimed.dicom.network.ULServiceMessage;

public class Reject
extends Response
implements ULServiceMessage {
    public static int REJECTED_PERMANENT = 1;
    public static int REJECTED_TRANSIENT = 2;
    public static int DICOM_UL_SERVICE_USER = 1;
    public static int DICOM_UL_SERVICE_PROVIDER_ACSE = 2;
    public static int DICOM_UL_SERVICE_PROVIDER_PRESENTATION = 3;
    public static int USER_NO_REASON_GIVEN = 1;
    public static int USER_APPLICATIONCONTEXTNAME_NOT_SUPPORTED = 2;
    public static int USER_CALLING_AETITLE_NOT_RECOGNIZED = 3;
    public static int USER_CALLED_AETITLE_NOT_RECOGNIZED = 7;
    public static int ACSE_NO_REASON_GIVEN = 1;
    public static int ACSE_PROTOCOL_NOT_SUPPORTED = 2;
    public static int PRESENTATION_TEMPORARY_CONGESTION = 1;
    public static int PRESENTATION_LOCAL_LIMIT_EXCEEDED = 2;
    private int result;
    private int source;
    private int reason;

    public Reject(int result, int source, int reason) {
        this.result = result;
        this.source = source;
        this.reason = reason;
    }

    public int getType() {
        return 3;
    }

    public int getMessageType() {
        return 1003;
    }

    public int getResult() {
        return this.result;
    }

    public int getSource() {
        return this.source;
    }

    public int getReason() {
        return this.reason;
    }

    public String toString() {
        String s = "[reject - result: ";
        s = this.result == REJECTED_PERMANENT ? s + "REJECTED_PERMANENT" : (this.result == REJECTED_TRANSIENT ? s + "REJECTED_TRANSIENT" : s + "UNKNOWN");
        s = s + " source: ";
        s = this.source == DICOM_UL_SERVICE_USER ? s + "DICOM_UL_SERVICE_USER" : (this.source == DICOM_UL_SERVICE_PROVIDER_ACSE ? s + "DICOM_UL_SERVICE_PROVIDER_ACSE" : (this.source == DICOM_UL_SERVICE_PROVIDER_PRESENTATION ? s + "DICOM_UL_SERVICE_PROVIDER_PRESENTATION" : s + "UNKNOWN"));
        s = s + " reason: ";
        s = this.reason == USER_NO_REASON_GIVEN ? s + "NO_REASON_GIVEN" : (this.reason == USER_APPLICATIONCONTEXTNAME_NOT_SUPPORTED ? s + "APPLICATIONCONTEXTNAME_NOT_SUPPORTED" : (this.reason == USER_CALLING_AETITLE_NOT_RECOGNIZED ? s + "CALLING_AETITLE_NOT_RECOGNIZED" : (this.reason == USER_CALLED_AETITLE_NOT_RECOGNIZED ? s + "CALLED_AETITLE_NOT_RECOGNIZED" : (this.reason == ACSE_NO_REASON_GIVEN ? s + "NO_REASON_GIVEN" : (this.reason == ACSE_PROTOCOL_NOT_SUPPORTED ? s + "PROTOCOL_NOT_SUPPORTED" : (this.reason == PRESENTATION_TEMPORARY_CONGESTION ? s + "TEMPORARY_CONGESTION" : (this.reason == PRESENTATION_LOCAL_LIMIT_EXCEEDED ? s + "LOCAL_LIMIT_EXCEEDED" : s + "UNKNOWN")))))));
        s = s + "]";
        return s;
    }
}

