/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.UIDEntry;
import com.archimed.dicom.network.TransferSyntaxItem;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

class PresentationContextResponseItem {
    private byte itemtype = (byte)33;
    private int id;
    private int length;
    private int result;
    TransferSyntaxItem traitem = new TransferSyntaxItem();

    public PresentationContextResponseItem() {
    }

    public PresentationContextResponseItem(int id, int result, TransferSyntaxItem traitem) {
        this.id = id;
        this.result = result;
        this.traitem = traitem;
        this.length = 4;
        if (traitem != null) {
            this.length += traitem.getLength();
        }
    }

    public int getID() {
        return this.id;
    }

    public int getResult() {
        return this.result;
    }

    public UIDEntry getTransferSyntax() {
        return this.traitem.getTransferSyntax();
    }

    public int getLength() {
        return this.length + 4;
    }

    public void write(DataOutputStream dout) throws IOException, IllegalValueException {
        dout.write(this.itemtype);
        dout.write(0);
        dout.writeChar(this.length);
        dout.write(this.id);
        dout.write(0);
        dout.write(this.result);
        dout.write(0);
        if (this.traitem != null) {
            this.traitem.write(dout);
        }
    }

    public int read(DataInputStream in) throws IllegalValueException, IOException {
        int b = in.read();
        if (b != this.itemtype) {
            throw new IllegalValueException("itemtype field of received Presentation Context Item  not " + this.itemtype);
        }
        in.read();
        this.length = in.readChar();
        this.id = in.read();
        in.read();
        this.result = in.read();
        in.read();
        if (this.result == 0) {
            this.traitem.read(in);
        } else {
            in.readFully(new byte[this.length - 4]);
        }
        return this.length + 4;
    }
}

