/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.network.AbstractSyntaxItem;
import com.archimed.dicom.network.TransferSyntaxItem;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;

class PresentationContextItem {
    private byte itemtype = (byte)32;
    private int id;
    private Vector traitems;
    private AbstractSyntaxItem absitem;

    public PresentationContextItem() {
    }

    public PresentationContextItem(int id, AbstractSyntaxItem absitem, Vector traitems) {
        this.id = id;
        this.absitem = absitem;
        this.traitems = traitems;
    }

    public int getID() {
        return this.id;
    }

    public int getLength() {
        return 4 + this.itemlengthPresCxtItem();
    }

    public AbstractSyntaxItem getAbstractSyntaxItem() {
        return this.absitem;
    }

    public Vector getTransferSyntaxes() {
        return this.traitems;
    }

    public void addTransferSyntaxItem(TransferSyntaxItem traitem) {
        this.traitems.addElement(traitem);
    }

    private int itemlengthPresCxtItem() {
        int length = 4;
        length += this.absitem.getLength();
        for (int j = 0; j < this.traitems.size(); ++j) {
            TransferSyntaxItem traitem = (TransferSyntaxItem)this.traitems.elementAt(j);
            length += traitem.getLength();
        }
        return length;
    }

    public void write(DataOutputStream out) throws IOException {
        out.write(this.itemtype);
        out.write(0);
        out.writeChar(this.itemlengthPresCxtItem());
        out.write(this.id);
        out.write(0);
        out.write(0);
        out.write(0);
        this.absitem.write(out);
        for (int i = 0; i < this.traitems.size(); ++i) {
            ((TransferSyntaxItem)this.traitems.elementAt(i)).write(out);
        }
    }

    int read(DataInputStream din) throws IOException, IllegalValueException {
        int length;
        int b = din.read();
        if (b != this.itemtype) {
            throw new IllegalValueException("wrong item type of presentation context item");
        }
        din.read();
        int length2 = length = din.readChar();
        this.id = din.read();
        din.read();
        din.read();
        din.read();
        length -= 4;
        this.absitem = new AbstractSyntaxItem();
        int r = this.absitem.read(din);
        length -= r;
        this.traitems = new Vector();
        while (length > 0) {
            TransferSyntaxItem traitem = new TransferSyntaxItem();
            r = traitem.read(din);
            this.traitems.addElement(traitem);
            length -= r;
        }
        return length2 + 4;
    }
}

