/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

import com.archimed.dicom.network.PduException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class PduBuffer {
    static final int MAXLENGTH = 0x100000;
    private byte[] buffer = new byte[6];

    public int getType() {
        return this.buffer[0] & 0xFF;
    }

    public int getLength() {
        int len = (this.buffer[2] & 0xFF) << 24 | (this.buffer[3] & 0xFF) << 16 | (this.buffer[4] & 0xFF) << 8 | (this.buffer[5] & 0xFF) << 0;
        return len + 6;
    }

    public byte[] getBytes() {
        return this.buffer;
    }

    public void setBytes(byte[] buf) throws PduException {
        if (buf.length < 6) {
            throw new PduException("byte array length must be >= 6");
        }
        int len = (buf[2] & 0xFF) << 24 | (buf[3] & 0xFF) << 16 | (buf[4] & 0xFF) << 8 | (buf[5] & 0xFF) << 0;
        if (buf.length != len + 6) {
            throw new PduException("byte array length different from pdu length + 6");
        }
        this.buffer = buf;
    }

    public void read(InputStream in) throws IOException {
        this.assureSize(6);
        this.readFully(in, this.buffer, 0, 6);
        int type = this.buffer[0] & 0xFF;
        int len = (this.buffer[2] & 0xFF) << 24 | (this.buffer[3] & 0xFF) << 16 | (this.buffer[4] & 0xFF) << 8 | (this.buffer[5] & 0xFF) << 0;
        if ((len & 0xFFFFFFFF) > 0x100000) {
            throw new IOException("Specified length (" + len + ") of PDU exceeds limit: " + 0x100000);
        }
        this.assureSize(6 + len);
        this.readFully(in, this.buffer, 6, len);
    }

    private void readFully(InputStream in, byte[] b, int off, int len) throws IOException {
        int count;
        for (int n = 0; n < len; n += count) {
            count = in.read(b, n + off, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    private void assureSize(int len) {
        if (this.buffer.length < len) {
            byte[] buffer = new byte[len];
            System.arraycopy(this.buffer, 0, buffer, 0, this.buffer.length);
            this.buffer = buffer;
        }
    }

    public void write(OutputStream out) throws IOException {
        out.write(this.buffer, 0, this.getLength());
    }
}

